/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.geometry.IndexedFaceSetUtility;
import de.jreality.scene.Appearance;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.ui.viewerapp.Selection;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionListener;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.util.LoggingSystem;
import de.jreality.util.Rectangle3D;
import de.jreality.util.Secure;
import java.awt.Color;
import java.util.LinkedList;
import java.util.Vector;
import java.util.WeakHashMap;

public class SelectionManagerImpl
implements SelectionManager {
    private Selection defaultSelection;
    private Selection selection;
    private Vector<SelectionListener> listeners;
    private boolean renderSelection = false;
    private SceneGraphComponent selectionKit;
    private SceneGraphComponent selectionKitOwner;
    static WeakHashMap<Viewer, SelectionManager> globalTable = new WeakHashMap();
    SceneGraphPath truncatedSelection = null;
    SceneGraphPath previousFullSelection;
    boolean cycling;
    private SceneGraphPath currentCycleSelection;
    private Vector<SceneGraphPath> selectionList = new Vector();
    private Appearance boundingboxApp = new Appearance("app");

    public static SelectionManager selectionManagerForViewer(Viewer viewer) {
        SelectionManager sm = globalTable.get(viewer);
        if (sm != null) {
            LoggingSystem.getLogger(SelectionManagerImpl.class).fine("Selection manager is " + sm);
            return sm;
        }
        LinkedList<Viewer> viewers = new LinkedList<Viewer>();
        Viewer v = viewer;
        viewers.add(v);
        if (v instanceof ViewerSwitch) {
            Viewer[] vs = ((ViewerSwitch)v).getViewers();
            sm = globalTable.get((ViewerSwitch)v);
            for (int i = 0; i < vs.length; ++i) {
                viewers.add(vs[i]);
                if (globalTable.get(vs[i]) == null) continue;
                if (sm != null && sm != globalTable.get(vs[i])) {
                    System.err.println("Distinct SelectionManagers used in viewer hierarchy of " + v);
                }
                sm = globalTable.get(vs[i]);
            }
        } else if (globalTable.get(v) != null) {
            if (sm != null && sm != globalTable.get(v)) {
                System.err.println("Distinct SelectionManagers used in viewer hierarchy of " + v);
            }
            sm = globalTable.get(v);
        }
        if (sm == null) {
            String selectionManager = Secure.getProperty("de.jreality.ui.viewerapp.SelectionManager", "de.jreality.ui.viewerapp.SelectionManagerImpl");
            try {
                sm = (SelectionManager)Class.forName(selectionManager).newInstance();
                sm.setDefaultSelection(new Selection(new SceneGraphPath(v.getSceneRoot())));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Viewer vw : viewers) {
            globalTable.put(vw, sm);
        }
        return sm;
    }

    public static void disposeForViewer(Viewer viewer) {
        if (viewer instanceof ViewerSwitch) {
            for (Viewer v : ((ViewerSwitch)viewer).getViewers()) {
                SelectionManagerImpl.disposeForViewer(v);
            }
        }
        globalTable.remove(viewer);
    }

    public SelectionManagerImpl() {
        this(null);
    }

    public SelectionManagerImpl(Selection defaultSelection) {
        this.listeners = new Vector();
        if (defaultSelection != null) {
            this.setDefaultSelection(defaultSelection);
        }
    }

    public Selection getDefaultSelection() {
        return this.defaultSelection;
    }

    public void setDefaultSelection(Selection defaultSelection) {
        this.defaultSelection = new Selection(defaultSelection);
        if (this.selection == null) {
            this.selection = defaultSelection;
        }
    }

    public Selection getSelection() {
        return this.selection == null ? this.defaultSelection : this.selection;
    }

    public void setSelection(Selection selection) {
        if (this.selection != null && this.selection.equals(selection)) {
            return;
        }
        this.selection = selection == null ? new Selection(this.defaultSelection) : new Selection(selection);
        if (!this.cycling) {
            this.previousFullSelection = new SceneGraphPath(this.selection.sgPath);
            this.truncatedSelection = null;
        }
        this.selectionChanged();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void selectionChanged() {
        if (!this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                SelectionListener l = this.listeners.get(i);
                l.selectionChanged(new SelectionEvent(this, this.selection));
            }
        }
        if (this.renderSelection) {
            this.updateBoundingBox();
        }
    }

    private void updateBoundingBox() {
        if (this.selection.getLastComponent() == this.selectionKit) {
            return;
        }
        if (this.selectionKit == null) {
            this.selectionKit = new SceneGraphComponent("boundingBox");
            this.selectionKit.setOwner(this);
            this.boundingboxApp.setAttribute("showLines", true);
            this.boundingboxApp.setAttribute("showFaces", false);
            this.boundingboxApp.setAttribute("showPoints", false);
            this.boundingboxApp.setAttribute("lightingEnabled", false);
            this.boundingboxApp.setAttribute("lineShader.lineStipple", true);
            this.boundingboxApp.setAttribute("lineShader.lineFactor", 1.0);
            this.boundingboxApp.setAttribute("lineShader.lineStipplePattern", 26214);
            this.boundingboxApp.setAttribute("lineShader.lineWidth", 2.0);
            this.boundingboxApp.setAttribute("lineShader.depthFudgeFactor", 1.0);
            this.boundingboxApp.setAttribute("lineShader.tubeDraw", false);
            this.boundingboxApp.setAttribute("levelOfDetail", 0.0);
            this.boundingboxApp.setAttribute("lineShader.diffuseColor", Color.WHITE);
            this.selectionKit.setAppearance(this.boundingboxApp);
        }
        System.err.println("Updating bb");
        Rectangle3D bbox = BoundingBoxUtility.calculateChildrenBoundingBox(this.selection.getLastComponent());
        IndexedFaceSet box = IndexedFaceSetUtility.representAsSceneGraph(null, bbox);
        this.selectionKit.setPickable(false);
        this.selectionKit.setGeometry(box);
        if (this.selectionKitOwner != null) {
            this.selectionKitOwner.removeChild(this.selectionKit);
        }
        this.selectionKitOwner = this.selection.getLastComponent();
        this.boundingboxApp.setAttribute("lineShader.lineStipple", this.selectionKitOwner.getTransformation() == null);
        this.selectionKitOwner.addChild(this.selectionKit);
    }

    public boolean isRenderSelection() {
        return this.renderSelection;
    }

    public void setRenderSelection(boolean renderSelection) {
        this.renderSelection = renderSelection;
        if (renderSelection) {
            this.updateBoundingBox();
        }
        if (this.selectionKit != null) {
            this.selectionKit.setVisible(renderSelection);
        }
    }

    public SceneGraphPath getDefaultSelectionPath() {
        return this.getDefaultSelection().getSGPath();
    }

    public SceneGraphPath getSelectionPath() {
        return this.getSelection().getSGPath();
    }

    public void setDefaultSelectionPath(SceneGraphPath defaultSelection) {
        this.setDefaultSelection(new Selection(defaultSelection));
    }

    public void setSelectionPath(SceneGraphPath selection) {
        if (selection == null || selection.getLength() == 0) {
            this.setSelection(this.defaultSelection);
        } else {
            this.setSelection(new Selection(selection));
        }
    }

    public void cycleSelectionPath() {
        if (this.truncatedSelection == null || this.truncatedSelection.getLength() <= 2) {
            this.truncatedSelection = new SceneGraphPath(this.previousFullSelection);
            LoggingSystem.getLogger(this).info("reached end");
        } else {
            this.truncatedSelection = this.truncatedSelection.popNew();
        }
        LoggingSystem.getLogger(this).info("truncated selection is " + this.truncatedSelection);
        this.cycling = true;
        this.setSelectionPath(this.truncatedSelection);
        this.cycling = false;
    }

    public void addSelection(SceneGraphPath p) {
        for (SceneGraphPath sgp : this.selectionList) {
            if (!sgp.isEqual(p)) continue;
            return;
        }
        this.selectionList.add(p);
        LoggingSystem.getLogger(this).fine("Adding path " + p.toString());
    }

    public void removeSelection(SceneGraphPath p) {
        for (SceneGraphPath sgp : this.selectionList) {
            if (!sgp.isEqual(p)) continue;
            if (this.currentCycleSelection != null && this.currentCycleSelection.equals(sgp)) {
                this.cycleSelection();
            }
            this.selectionList.remove(sgp);
            LoggingSystem.getLogger(this).info("Removing path " + p.toString());
            return;
        }
    }

    public void clearSelections() {
        this.selectionList.clear();
    }

    public void cycleSelection() {
        int which;
        int target = 0;
        if (this.selectionList == null || this.selectionList.size() == 0) {
            return;
        }
        if (this.currentCycleSelection != null && (which = this.selectionList.indexOf(this.currentCycleSelection)) != -1) {
            target = (which + 1) % this.selectionList.size();
        }
        this.currentCycleSelection = this.selectionList.get(target);
        LoggingSystem.getLogger(this).info("Cycling selection to " + this.currentCycleSelection.toString());
        this.setSelectionPath(this.currentCycleSelection);
    }
}

