/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.data.AttributeEntity;
import de.jreality.scene.tool.Tool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selection {
    protected SceneGraphPath sgPath = new SceneGraphPath();
    protected LinkedList<Object> tail = new LinkedList();

    public Selection() {
    }

    public Selection(Selection s) {
        this(s.sgPath);
        this.tail.addAll(s.tail);
    }

    public Selection(SceneGraphPath path) {
        this();
        this.sgPath = new SceneGraphPath(path);
    }

    public void clear() {
        this.sgPath.clear();
        this.tail.clear();
    }

    public final void push(Object o) {
        if (this.tail.isEmpty() && o instanceof SceneGraphNode) {
            this.sgPath.push((SceneGraphNode)o);
        } else {
            this.tail.add(o);
        }
    }

    public final void pop() {
        if (this.tail.isEmpty()) {
            this.sgPath.pop();
        } else {
            this.tail.removeLast();
        }
    }

    public SceneGraphNode getFirstElement() {
        return this.sgPath.getFirstElement();
    }

    public SceneGraphPath getSGPath() {
        return this.sgPath;
    }

    public SceneGraphComponent getLastComponent() {
        return this.sgPath.getLastComponent();
    }

    public SceneGraphNode getLastNode() {
        return this.sgPath.getLastElement();
    }

    public Object getLastElement() {
        if (this.tail.isEmpty()) {
            return this.getLastNode();
        }
        return this.tail.getLast();
    }

    public boolean isSGPath() {
        return this.tail.isEmpty();
    }

    public int getLength() {
        return this.sgPath.getLength() + this.tail.size();
    }

    public int hashCode() {
        int result = 1;
        for (Object element : this.toList()) {
            result = 31 * result + element.hashCode();
        }
        return result;
    }

    public boolean equals(Object s) {
        if (s instanceof Selection) {
            return this.isEqual((Selection)s);
        }
        return false;
    }

    public boolean isEqual(Selection anotherSelection) {
        if (anotherSelection == null || this.getLength() != anotherSelection.getLength()) {
            return false;
        }
        List<Object> l1 = this.toList();
        List<Object> l2 = anotherSelection.toList();
        for (int i = 0; i < this.getLength(); ++i) {
            if (l1.get(i).equals(l2.get(i))) continue;
            return false;
        }
        return true;
    }

    public ListIterator<Object> iterator() {
        return Collections.unmodifiableList(this.toList()).listIterator();
    }

    public ListIterator<Object> iterator(int start) {
        return Collections.unmodifiableList(this.toList()).listIterator(start);
    }

    public Iterator reverseIterator() {
        return this.reverseIterator(this.getLength());
    }

    public Iterator reverseIterator(int start) {
        final ListIterator<Object> iter = this.iterator(start);
        return new Iterator(){

            public void remove() {
                iter.remove();
            }

            public boolean hasNext() {
                return iter.hasPrevious();
            }

            public Object next() {
                return iter.previous();
            }
        };
    }

    public List<Object> toList() {
        ArrayList<Object> list = new ArrayList<Object>(this.getLength());
        list.addAll(this.sgPath.toList());
        list.addAll(this.tail);
        return list;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.sgPath.toString());
        for (Object e : this.tail) {
            str.append(" : ").append(e.toString());
        }
        return str.toString();
    }

    public boolean isTool() {
        return !this.tail.isEmpty() && this.tail.getLast() instanceof Tool;
    }

    public Tool asTool() {
        if (this.isTool()) {
            return (Tool)this.getLastElement();
        }
        return null;
    }

    public boolean isComponent() {
        return this.isNode() && this.getLastNode() instanceof SceneGraphComponent;
    }

    public SceneGraphComponent asComponent() {
        if (this.isComponent()) {
            return this.sgPath.getLastComponent();
        }
        return null;
    }

    public boolean isNode() {
        return this.tail.isEmpty() && this.sgPath.getLength() != 0;
    }

    public SceneGraphNode asNode() {
        if (this.isNode()) {
            return this.getLastNode();
        }
        return null;
    }

    public boolean isEntity() {
        return !this.tail.isEmpty() && this.tail.getLast() instanceof AttributeEntity;
    }

    public AttributeEntity asEntity() {
        if (this.isEntity()) {
            return (AttributeEntity)this.getLastElement();
        }
        return null;
    }
}

