/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.ui.viewerapp.FileFilter;
import de.jreality.util.Secure;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FileLoaderDialog {
    static File lastDir = new File(Secure.getProperty("jreality.data", "/net/MathVis/data/testData3D"));

    public static void setLastDir(File dir) {
        lastDir = dir;
    }

    public static File getLastDir() {
        return lastDir;
    }

    public static JFileChooser createFileChooser() {
        return FileLoaderDialog.createFileChooser(true, FileFilter.createJRealityDataFilter());
    }

    public static JFileChooser createFileChooser(String ext, String description) {
        return FileLoaderDialog.createFileChooser(true, new FileFilter(description, ext));
    }

    public static JFileChooser createFileChooser(boolean useAcceptAllFileFilter, javax.swing.filechooser.FileFilter ... ff) {
        FileSystemView view = FileSystemView.getFileSystemView();
        JFileChooser chooser = new JFileChooser(!lastDir.exists() ? view.getHomeDirectory() : lastDir, view);
        chooser.setAcceptAllFileFilterUsed(useAcceptAllFileFilter);
        for (int i = 0; i < ff.length; ++i) {
            chooser.addChoosableFileFilter(ff[i]);
        }
        if (ff.length != 0) {
            chooser.setFileFilter(ff[0]);
        } else if (useAcceptAllFileFilter) {
            chooser.setFileFilter(chooser.getAcceptAllFileFilter());
        }
        return chooser;
    }

    private static File[] loadFiles(Component parent, JFileChooser chooser, JComponent accessory) {
        if (accessory != null) {
            chooser.setAccessory(accessory);
        }
        chooser.setMultiSelectionEnabled(true);
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        File[] files = chooser.getSelectedFiles();
        lastDir = chooser.getCurrentDirectory();
        return files;
    }

    private static File loadFile(Component parent, JFileChooser chooser, JComponent accessory) {
        if (accessory != null) {
            chooser.setAccessory(accessory);
        }
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(parent) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        lastDir = chooser.getCurrentDirectory();
        return file;
    }

    public static File[] loadFiles(Component parent) {
        return FileLoaderDialog.loadFiles(parent, null);
    }

    public static File[] loadFiles(Component parent, JComponent accessory) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser();
        return FileLoaderDialog.loadFiles(parent, chooser, accessory);
    }

    public static File loadFile(Component parent, String extension, String description) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser(extension, description);
        return FileLoaderDialog.loadFile(parent, chooser, (JComponent)null);
    }

    public static File loadFile(Component parent, boolean useAcceptAllFileFilter, javax.swing.filechooser.FileFilter ... ff) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser(useAcceptAllFileFilter, ff);
        return FileLoaderDialog.loadFile(parent, chooser, (JComponent)null);
    }

    public static File loadFile(Component parent, JComponent accessory) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser(true, new javax.swing.filechooser.FileFilter[0]);
        return FileLoaderDialog.loadFile(parent, chooser, accessory);
    }

    private static File selectTargetFile(Component parent, final JFileChooser chooser, JComponent accessory) {
        int choice;
        if (accessory != null) {
            chooser.setAccessory(accessory);
        }
        chooser.setMultiSelectionEnabled(false);
        chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                try {
                    BasicFileChooserUI ui = (BasicFileChooserUI)chooser.getUI();
                    chooser.setSelectedFile(new File(ui.getFileName()));
                    chooser.updateUI();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        File file = null;
        while ((choice = chooser.showSaveDialog(parent)) == 0) {
            File chosen = chooser.getSelectedFile();
            try {
                String extension;
                FileFilter filter = (FileFilter)chooser.getFileFilter();
                if (!filter.accept(chosen) && (extension = filter.getPreferredExtension()) != null) {
                    chosen = new File(chosen.getPath() + "." + extension);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!chosen.exists()) {
                file = chosen;
                break;
            }
            int confirm = JOptionPane.showConfirmDialog(parent, "Overwrite file " + chosen.getName() + "?");
            if (confirm == 0) {
                file = chosen;
                break;
            }
            if (confirm == 1) continue;
        }
        lastDir = chooser.getCurrentDirectory();
        return file;
    }

    public static File selectTargetFile(Component parent) {
        return FileLoaderDialog.selectTargetFile(parent, null);
    }

    public static File selectTargetFile(Component parent, JComponent accessory) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser();
        return FileLoaderDialog.selectTargetFile(parent, chooser, accessory);
    }

    public static File selectTargetFile(Component parent, String extension, String description) {
        return FileLoaderDialog.selectTargetFile(parent, (JComponent)null, extension, description);
    }

    public static File selectTargetFile(Component parent, JComponent accessory, String extension, String description) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser(extension, description);
        return FileLoaderDialog.selectTargetFile(parent, chooser, accessory);
    }

    public static File selectTargetFile(Component parent, boolean useAcceptAllFileFilter, javax.swing.filechooser.FileFilter ... ff) {
        return FileLoaderDialog.selectTargetFile(parent, (JComponent)null, useAcceptAllFileFilter, ff);
    }

    public static File selectTargetFile(Component parent, JComponent accessory, boolean useAcceptAllFileFilter, javax.swing.filechooser.FileFilter ... ff) {
        JFileChooser chooser = FileLoaderDialog.createFileChooser(useAcceptAllFileFilter, ff);
        return FileLoaderDialog.selectTargetFile(parent, chooser, accessory);
    }
}

