/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.reader.Readers;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.imageio.ImageIO;

public class FileFilter
extends javax.swing.filechooser.FileFilter {
    private HashSet<String> extensions;
    private String preferred;
    private String description;
    private boolean showExtensionList = true;

    public FileFilter() {
        this(null, new String[0]);
    }

    public FileFilter(String description, String ... extensions) {
        this.setDescription(description);
        this.extensions = new LinkedHashSet<String>();
        for (int i = 0; i < extensions.length; ++i) {
            this.addExtension(extensions[i]);
        }
    }

    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileFilter.getFileExtension(f);
        return extension != null && (this.extensions.contains(extension) || this.extensions.contains(extension.toLowerCase()) || this.extensions.contains(extension.toUpperCase()));
    }

    public String getDescription() {
        if (!this.showExtensionList || this.extensions.isEmpty()) {
            return this.description;
        }
        String extensionList = null;
        for (String extension : this.extensions) {
            if (extensionList == null) {
                extensionList = " (*." + extension;
                continue;
            }
            extensionList = extensionList + ", *." + extension;
        }
        extensionList = extensionList + ")";
        return this.description + extensionList;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addExtension(String extension) {
        this.extensions.add(extension);
    }

    public void setPreferredExtension(String preferred) {
        this.addExtension(preferred);
        this.preferred = preferred;
    }

    public String getPreferredExtension() {
        if (this.preferred == null && !this.extensions.isEmpty()) {
            return this.extensions.iterator().next();
        }
        return this.preferred;
    }

    public static String getFileExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public boolean isShowExtensionList() {
        return this.showExtensionList;
    }

    public void setShowExtensionList(boolean showExtensionList) {
        this.showExtensionList = showExtensionList;
    }

    public static FileFilter createJRealityDataFilter() {
        FileFilter f = new FileFilter("jReality 3D data files", new String[0]){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String filename = f.getName().toLowerCase();
                return Readers.findFormat(filename) != null;
            }
        };
        f.setShowExtensionList(false);
        return f;
    }

    public static javax.swing.filechooser.FileFilter[] createImageWriterFilters() {
        String[] writerFormats = ImageIO.getWriterFormatNames();
        String[] known = new String[]{"bmp", "jpg", "jpeg", "png", "wbmp", "tiff", "tif"};
        HashSet<String> special = new HashSet<String>();
        block2: for (int i = 0; i < writerFormats.length; ++i) {
            String ext = writerFormats[i].toLowerCase();
            for (int j = 0; j < known.length; ++j) {
                if (known[j].equals(ext)) continue block2;
            }
            special.add(ext);
        }
        LinkedHashSet<FileFilter> filters = new LinkedHashSet<FileFilter>();
        FileFilter general = new FileFilter("All Image Files", known);
        for (String s : special) {
            general.addExtension(s);
        }
        general.setPreferredExtension("png");
        filters.add(general);
        filters.add(new FileFilter("PNG Image", "png"));
        filters.add(new FileFilter("JPEG Image", "jpg", "jpeg"));
        try {
            Class.forName("javax.media.jai.JAI");
            filters.add(new FileFilter("TIFF Image", "tiff", "tif"));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        filters.add(new FileFilter("BMP Image", "bmp"));
        filters.add(new FileFilter("Wireless BMP Image", "wbmp"));
        for (String s : special) {
            filters.add(new FileFilter(s.toUpperCase() + " Image", s));
        }
        FileFilter[] ff = new FileFilter[filters.size()];
        return filters.toArray(ff);
    }

    public static javax.swing.filechooser.FileFilter[] createImageReaderFilters() {
        String[] readerFormats = ImageIO.getReaderFormatNames();
        String[] known = new String[]{"bmp", "gif", "jpg", "jpeg", "png", "wbmp"};
        HashSet<String> special = new HashSet<String>();
        block0: for (int i = 0; i < readerFormats.length; ++i) {
            String ext = readerFormats[i].toLowerCase();
            for (int j = 0; j < known.length; ++j) {
                if (known[j].equals(ext)) continue block0;
            }
            special.add(ext);
        }
        LinkedHashSet<FileFilter> filters = new LinkedHashSet<FileFilter>();
        FileFilter general = new FileFilter("All Image Files", known);
        for (String s : special) {
            general.addExtension(s);
        }
        general.setPreferredExtension("png");
        filters.add(general);
        filters.add(new FileFilter("PNG Image", "png"));
        filters.add(new FileFilter("JPEG Image", "jpg", "jpeg"));
        filters.add(new FileFilter("GIF Image", "gif"));
        filters.add(new FileFilter("BMP Image", "bmp"));
        filters.add(new FileFilter("Wireless BMP Image", "wbmp"));
        for (String s : special) {
            filters.add(new FileFilter(s.toUpperCase() + " Image", s));
        }
        FileFilter[] ff = new FileFilter[filters.size()];
        return filters.toArray(ff);
    }
}

