/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import bsh.EvalError;
import de.jreality.scene.SceneGraphNode;
import de.jreality.ui.viewerapp.SelectionEvent;
import de.jreality.ui.viewerapp.SelectionListener;
import de.jreality.ui.viewerapp.SelectionManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.Proxy;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import jterm.BshEvaluator;
import jterm.JTerm;
import jterm.Session;
import jterm.StringEvaluator;

public class BeanShell
implements SelectionListener {
    private BshEvaluator bshEval = new BshEvaluator();
    private JTerm jterm = new JTerm(new Session((StringEvaluator)this.bshEval));
    private SimpleAttributeSet infoStyle;
    private Component beanShell;

    public BeanShell() {
        this(null);
    }

    public BeanShell(SelectionManager sm) {
        this.jterm.setMaximumSize(new Dimension(10, 10));
        this.infoStyle = new SimpleAttributeSet();
        StyleConstants.setForeground(this.infoStyle, new Color(65, 166, 48));
        StyleConstants.setFontFamily(this.infoStyle, "Monospaced");
        StyleConstants.setBold(this.infoStyle, true);
        StyleConstants.setFontSize(this.infoStyle, 12);
        if (sm != null) {
            sm.addSelectionListener(this);
            this.setSelf(sm.getSelection().getLastElement());
        }
    }

    public void selectionChanged(SelectionEvent e) {
        this.setSelf(e.getSelection().getLastElement());
    }

    public void eval(String arg) {
        try {
            this.bshEval.getInterpreter().eval(arg);
        }
        catch (EvalError error) {
            error.printStackTrace();
        }
    }

    public Component getComponent() {
        if (this.beanShell == null) {
            this.beanShell = new JScrollPane((Component)this.jterm);
            ((JScrollPane)this.beanShell).setBorder(BorderFactory.createEmptyBorder());
        }
        return this.beanShell;
    }

    public void setSelf(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj.equals(this.bshEval.getInterpreter().get("self"))) {
                return;
            }
            this.bshEval.getInterpreter().set("self", obj);
            String name = obj instanceof SceneGraphNode ? ((SceneGraphNode)obj).getName() : "";
            String type = Proxy.isProxyClass(obj.getClass()) ? obj.getClass().getInterfaces()[0].getName() : obj.getClass().getName();
            String info = "\nself=" + name + "[" + type + "]\n";
            try {
                this.jterm.getSession().displayAndPrompt(info, (AttributeSet)this.infoStyle);
                this.jterm.setCaretPosition(this.jterm.getDocument().getLength());
            }
            catch (Exception exc) {}
        }
        catch (EvalError error) {
            error.printStackTrace();
        }
    }

    public BshEvaluator getBshEval() {
        return this.bshEval;
    }
}

