/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.viewerapp;

import de.jreality.io.JrScene;
import de.jreality.io.JrSceneFactory;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Viewer;
import de.jreality.scene.pick.AABBPickSystem;
import de.jreality.toolsystem.ToolSystem;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.ui.viewerapp.BeanShell;
import de.jreality.ui.viewerapp.Navigator;
import de.jreality.ui.viewerapp.Selection;
import de.jreality.ui.viewerapp.SelectionManager;
import de.jreality.ui.viewerapp.SelectionManagerImpl;
import de.jreality.ui.viewerapp.ViewerAppMenu;
import de.jreality.ui.viewerapp.ViewerSwitch;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.RenderTrigger;
import de.jreality.util.Secure;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.security.PrivilegedAction;

public abstract class AbstractViewerApp {
    protected Viewer[] viewers = null;
    protected ViewerSwitch viewerSwitch;
    protected ToolSystem toolSystem;
    protected RenderTrigger renderTrigger;
    protected boolean autoRender = true;
    protected boolean synchRender = false;
    protected boolean propagateSelection = true;
    protected JrScene jrScene;
    protected SceneGraphComponent sceneRoot;
    protected SceneGraphComponent scene;
    protected SceneGraphNode displayedNode;
    protected SelectionManager selectionManager;
    protected BeanShell beanShell;
    protected Navigator navigator;
    protected boolean attachNavigator = false;
    protected boolean attachBeanShell = false;
    protected boolean externalBeanShell = false;
    protected boolean externalNavigator = false;
    protected boolean showMenu = true;
    protected boolean createMenu = true;
    protected boolean onlyBuildsoftware = false;
    public static Color[] defaultBackgroundColor = new Color[]{new Color(225, 225, 225), new Color(225, 225, 225), new Color(255, 225, 180), new Color(255, 225, 180)};

    public AbstractViewerApp() {
    }

    public AbstractViewerApp(SceneGraphNode node) {
        this(node, null, null, null, null);
    }

    public AbstractViewerApp(SceneGraphNode node, boolean softwareOnly) {
        this.onlyBuildsoftware = softwareOnly;
        this.init(node, null, null, null, null);
    }

    public AbstractViewerApp(SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        this(null, root, cameraPath, emptyPick, avatar);
    }

    public AbstractViewerApp(JrScene scene) {
        this(scene.getSceneRoot(), scene.getPath("cameraPath"), scene.getPath("emptyPickPath"), scene.getPath("avatarPath"));
    }

    public AbstractViewerApp(Viewer[] vs) {
        this.viewers = vs;
        this.init(null, vs[0].getSceneRoot(), vs[0].getCameraPath(), null, null);
    }

    public AbstractViewerApp(SceneGraphNode contentNode, SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        this.init(contentNode, root, cameraPath, emptyPick, avatar);
    }

    protected void init(SceneGraphNode contentNode, SceneGraphComponent root, SceneGraphPath cameraPath, SceneGraphPath emptyPick, SceneGraphPath avatar) {
        String synchRenderProp;
        if (contentNode != null && !(contentNode instanceof Geometry) && !(contentNode instanceof SceneGraphComponent)) {
            throw new IllegalArgumentException("Only Geometry or SceneGraphComponent allowed!");
        }
        if (root == null) {
            this.jrScene = this.getDefaultScene();
        } else {
            JrScene s = new JrScene();
            s.setSceneRoot(root);
            if (cameraPath != null) {
                s.addPath("cameraPath", cameraPath);
            }
            if (avatar != null) {
                s.addPath("avatarPath", avatar);
            }
            if (emptyPick != null) {
                s.addPath("emptyPickPath", emptyPick);
            }
            this.jrScene = s;
        }
        this.displayedNode = contentNode;
        String autoRenderProp = Secure.getProperty("de.jreality.ui.viewerapp.autoRender", "true");
        if (autoRenderProp.equalsIgnoreCase("false")) {
            this.autoRender = false;
        }
        if ((synchRenderProp = Secure.getProperty("de.jreality.ui.viewerapp.synchRender", "true")).equalsIgnoreCase("true")) {
            this.synchRender = true;
        }
        if (this.autoRender) {
            this.renderTrigger = new RenderTrigger();
        }
        if (this.synchRender) {
            if (this.autoRender) {
                this.renderTrigger.setAsync(false);
            } else {
                LoggingSystem.getLogger(this).config("Inconsistant settings: no autoRender but synchRender!!");
            }
        }
        this.setupViewer(this.jrScene);
        this.selectionManager = SelectionManagerImpl.selectionManagerForViewer(this.getViewer());
        SceneGraphPath p = this.getToolSystem().getEmptyPickPath();
        if (p == null) {
            p = new SceneGraphPath();
            p.push(this.getViewerSwitch().getSceneRoot());
        }
        this.selectionManager.setDefaultSelection(new Selection(p));
        this.selectionManager.setSelection(this.selectionManager.getDefaultSelection());
    }

    public abstract void display();

    public abstract void update();

    private JrScene getDefaultScene() {
        String environment = Secure.getProperty("de.jreality.viewerapp.env", "desktop");
        if (environment.equals("desktop")) {
            return JrSceneFactory.getDefaultDesktopScene();
        }
        if (environment.equals("portal")) {
            return JrSceneFactory.getDefaultPortalScene();
        }
        if (environment.equals("portal-remote")) {
            return JrSceneFactory.getDefaultPortalRemoteScene();
        }
        throw new IllegalStateException("unknown environment: " + environment);
    }

    protected void setupViewer(JrScene sc) {
        SceneGraphPath path;
        if (this.viewerSwitch != null) {
            if (this.autoRender) {
                this.renderTrigger.removeViewer(this.viewerSwitch);
                if (this.viewerSwitch.getSceneRoot() != null) {
                    this.renderTrigger.removeSceneGraphComponent(this.viewerSwitch.getSceneRoot());
                }
            }
            this.viewerSwitch.dispose();
        }
        if (this.toolSystem != null) {
            this.toolSystem.dispose();
        }
        this.toolSystem = Secure.doPrivileged(new PrivilegedAction<ToolSystem>(){

            @Override
            public ToolSystem run() {
                try {
                    return AbstractViewerApp.this.createToolSystem();
                }
                catch (Exception exc) {
                    throw new RuntimeException(exc);
                }
            }
        });
        if (this.toolSystem.getPickSystem() == null) {
            this.toolSystem.setPickSystem(new AABBPickSystem());
        }
        this.sceneRoot = sc.getSceneRoot();
        this.viewerSwitch.setSceneRoot(this.sceneRoot);
        if (this.autoRender) {
            this.renderTrigger.addViewer(this.viewerSwitch);
            this.renderTrigger.addSceneGraphComponent(this.sceneRoot);
        }
        if ((path = sc.getPath("cameraPath")) != null) {
            this.viewerSwitch.setCameraPath(path);
        }
        if ((path = sc.getPath("avatarPath")) != null) {
            this.toolSystem.setAvatarPath(path);
        }
        if ((path = sc.getPath("emptyPickPath")) != null) {
            this.scene = path.getLastComponent();
            this.toolSystem.setEmptyPickPath(path);
        }
        this.toolSystem.initializeSceneTools();
        if (this.displayedNode != null) {
            SceneGraphNode node = this.displayedNode;
            node.accept(new SceneGraphVisitor(){

                public void visit(SceneGraphComponent sc) {
                    AbstractViewerApp.this.scene.addChild(sc);
                }

                public void visit(Geometry g) {
                    AbstractViewerApp.this.scene.setGeometry(g);
                }
            });
        }
    }

    protected abstract ToolSystem createToolSystem() throws IOException;

    protected ToolSystemConfiguration loadToolSystemConfiguration(final String config) {
        return Secure.doPrivileged(new PrivilegedAction<ToolSystemConfiguration>(){

            @Override
            public ToolSystemConfiguration run() {
                ToolSystemConfiguration cfg = null;
                try {
                    if (config.contains("://")) {
                        cfg = ToolSystemConfiguration.loadConfiguration(new Input(new URL(config)));
                    } else {
                        if (config.equals("default")) {
                            cfg = ToolSystemConfiguration.loadDefaultDesktopConfiguration();
                        }
                        if (config.equals("defaultSwt")) {
                            cfg = ToolSystemConfiguration.loadDefaultDesktopSwtConfiguration();
                        }
                        if (config.equals("portal")) {
                            cfg = ToolSystemConfiguration.loadDefaultPortalConfiguration();
                        }
                        if (config.equals("portal-remote")) {
                            cfg = ToolSystemConfiguration.loadRemotePortalConfiguration();
                        }
                        if (config.equals("default+portal")) {
                            cfg = ToolSystemConfiguration.loadDefaultDesktopAndPortalConfiguration();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (cfg == null) {
                    throw new IllegalStateException("couldn't load config [" + config + "]");
                }
                return cfg;
            }
        });
    }

    protected Viewer createViewer(String viewer) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        return (Viewer)Class.forName(viewer).newInstance();
    }

    protected abstract void setupBeanShell();

    protected abstract void setupNavigator();

    public abstract void showExternalNavigator(boolean var1);

    public abstract void showExternalBeanShell(boolean var1);

    public void setAttachNavigator(boolean b) {
        this.attachNavigator = b;
    }

    public void setAttachBeanShell(boolean b) {
        this.attachBeanShell = b;
    }

    public SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public void setPropagateSelection(boolean b) {
        this.propagateSelection = b;
        if (this.navigator != null) {
            this.navigator.setPropagateSelections(b);
        }
    }

    public Viewer getViewer() {
        return this.getViewerSwitch();
    }

    public Viewer getCurrentViewer() {
        return this.viewerSwitch.getCurrentViewer();
    }

    public ViewerSwitch getViewerSwitch() {
        return this.viewerSwitch;
    }

    public ToolSystem getToolSystem() {
        return this.toolSystem;
    }

    public JrScene getJrScene() {
        return this.jrScene;
    }

    public SceneGraphComponent getSceneRoot() {
        return this.sceneRoot;
    }

    public boolean isAttachBeanShell() {
        return this.attachBeanShell;
    }

    public boolean isAttachNavigator() {
        return this.attachNavigator;
    }

    public void setIncludeMenu(boolean b) {
        this.setCreateMenu(b);
    }

    public boolean isIncludeMenu() {
        return this.isCreateMenu();
    }

    public void setCreateMenu(boolean b) {
        this.createMenu = b;
    }

    public boolean isCreateMenu() {
        return this.createMenu;
    }

    public void setShowMenu(boolean b) {
        this.showMenu = b;
    }

    public boolean isShowMenu() {
        return this.showMenu;
    }

    public abstract ViewerAppMenu getMenu();

    public boolean isExternalNavigator() {
        return this.externalNavigator;
    }

    public void setExternalNavigator(boolean externalNavigator) {
        this.externalNavigator = externalNavigator;
    }

    public boolean isExternalBeanShell() {
        return this.externalBeanShell;
    }

    public void setExternalBeanShell(boolean externalBeanShell) {
        this.externalBeanShell = externalBeanShell;
    }

    public void setBackgroundColor(Color ... colors) {
        if (colors == null || colors.length != 1 && colors.length != 4) {
            throw new IllegalArgumentException("illegal length of colors[]");
        }
        if (this.sceneRoot.getAppearance() == null) {
            this.sceneRoot.setAppearance(new Appearance());
        }
        if (colors.length == 4) {
            boolean equal = true;
            for (int i = 1; i < colors.length; ++i) {
                if (colors[i] == colors[0]) continue;
                equal = false;
            }
            if (equal) {
                colors = new Color[]{colors[0]};
            }
        }
        this.sceneRoot.getAppearance().setAttribute("backgroundColor", colors.length == 1 ? colors[0] : Appearance.INHERITED);
        this.sceneRoot.getAppearance().setAttribute("backgroundColors", colors.length == 4 ? colors : Appearance.INHERITED);
    }

    public abstract void dispose();
}

