/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.treeview;

import de.jreality.scene.Appearance;
import de.jreality.scene.AudioSource;
import de.jreality.scene.Camera;
import de.jreality.scene.Geometry;
import de.jreality.scene.Light;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphVisitor;
import de.jreality.scene.Transformation;
import de.jreality.scene.data.AttributeEntity;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.ui.treeview.SceneTreeModel;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class JTreeRenderer
extends DefaultTreeCellRenderer {
    static final ImageIcon trafoIcon = JTreeRenderer.createImageIcon("icons/TrafoIcon.jpg");
    static final ImageIcon camIcon = JTreeRenderer.createImageIcon("icons/CamIcon.jpg");
    static final ImageIcon geomIcon = JTreeRenderer.createImageIcon("icons/GeometryIcon.jpg");
    static final ImageIcon sgcIcon = JTreeRenderer.createImageIcon("icons/SceneGraphComponentIcon.jpg");
    static final ImageIcon sgcOwnedIcon = JTreeRenderer.createImageIcon("icons/SceneGraphComponentOwnedIcon.jpg");
    static final ImageIcon sgcInvisibleIcon = JTreeRenderer.createImageIcon("icons/SceneGraphComponentInvisibleIcon.jpg");
    static final ImageIcon appIcon = JTreeRenderer.createImageIcon("icons/AppearanceIcon.jpg");
    static final ImageIcon lightIcon = JTreeRenderer.createImageIcon("icons/LightIcon.jpg");
    static final ImageIcon shaderIcon = JTreeRenderer.createImageIcon("icons/ShaderIcon.jpg");
    static final ImageIcon toolIcon = JTreeRenderer.createImageIcon("icons/ToolIcon.jpg");
    static final ImageIcon audioIcon = JTreeRenderer.createImageIcon("icons/AudioSourceIcon.jpg");
    final SceneGraphVisitor iconSelector = new SceneGraphVisitor(){

        public void visit(Appearance a) {
            JTreeRenderer.this.setIcon(appIcon);
        }

        public void visit(Geometry g) {
            JTreeRenderer.this.setIcon(geomIcon);
        }

        public void visit(SceneGraphComponent c) {
            if (c.getOwner() != null) {
                JTreeRenderer.this.setIcon(sgcOwnedIcon);
            } else if (c.isVisible()) {
                JTreeRenderer.this.setIcon(sgcIcon);
            } else {
                JTreeRenderer.this.setIcon(sgcInvisibleIcon);
            }
        }

        public void visit(Transformation t) {
            JTreeRenderer.this.setIcon(trafoIcon);
        }

        public void visit(Camera c) {
            JTreeRenderer.this.setIcon(camIcon);
        }

        public void visit(Light l) {
            JTreeRenderer.this.setIcon(lightIcon);
        }

        public void visit(AudioSource a) {
            JTreeRenderer.this.setIcon(audioIcon);
        }
    };
    final StringBuffer buffer = new StringBuffer(30);

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = JTreeRenderer.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        String ifName;
        if (value instanceof SceneTreeNode) {
            SceneGraphNode m = ((SceneTreeNode)value).getNode();
            this.buffer.append(m.getName());
        } else if (value instanceof AttributeEntity) {
            ifName = value.getClass().getInterfaces()[0].getName();
            this.buffer.append(ifName.substring(ifName.lastIndexOf(".") + 1));
        } else if (value instanceof SceneTreeModel.TreeTool) {
            ifName = ((SceneTreeModel.TreeTool)value).getTool().getClass().getName();
            this.buffer.append(ifName.substring(ifName.lastIndexOf(".") + 1));
        }
        Component c = super.getTreeCellRendererComponent(tree, this.buffer.toString(), selected, expanded, leaf, row, focus);
        this.buffer.setLength(0);
        if (value instanceof SceneTreeNode) {
            ((SceneTreeNode)value).getNode().accept(this.iconSelector);
        } else if (value instanceof AttributeEntity) {
            this.setIcon(shaderIcon);
        } else if (value instanceof SceneTreeModel.TreeTool) {
            this.setIcon(toolIcon);
        }
        return c;
    }
}

