/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.ui.treeview;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    ArrayList<TreeModelListener> listeners;
    Object root;

    protected AbstractTreeModel(Object root) {
        this.root = root;
        this.listeners = new ArrayList();
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireNodesAdded(Object parent, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireNodesAdded(parent, this.getIndicesFor(parent, child), child);
    }

    protected void fireNodesAdded(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesInserted(e);
        }
    }

    protected void fireNodesChanged(Object parent, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.fireNodesChanged(parent, this.getIndicesFor(parent, child), child);
    }

    protected void fireNodesChanged(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesChanged(e);
        }
    }

    protected void fireTreeStructureChanged(Object parent) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent));
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeStructureChanged(e);
        }
    }

    protected void fireNodesRemoved(Object parent, int[] indices, Object[] child) {
        if (this.listeners.isEmpty()) {
            return;
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathTo(parent), indices, child);
        for (int i = this.listeners.size() - 1; i > -1; --i) {
            TreeModelListener tml = this.listeners.get(i);
            tml.treeNodesRemoved(e);
        }
    }

    public TreePath getPathTo(Object o) {
        Object root = this.getRoot();
        ArrayList<Object> path = new ArrayList<Object>();
        path.add(o);
        Object p = o;
        while (!root.equals(p)) {
            p = this.getParent(p);
            path.add(p);
        }
        Collections.reverse(path);
        return new TreePath(path.toArray());
    }

    protected int[] getIndicesFor(Object parent, Object[] child) {
        int[] indices = new int[child.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = this.getIndexOfChild(parent, child[i]);
        }
        return indices;
    }

    public abstract Object getChild(Object var1, int var2);

    public abstract int getChildCount(Object var1);

    public int getIndexOfChild(Object parent, Object child) {
        int l = this.getChildCount(parent);
        for (int i = 0; i < l; ++i) {
            if (this.getChild(parent, i) != child) continue;
            return i;
        }
        return -1;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public abstract Object getParent(Object var1);
}

