/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VirtualSpaceNavigatorFixAxisFirst
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    AxisState state;
    double eps = 0.06;
    static final int num = 4;
    List<Double> list = new LinkedList<Double>();
    double CriticalRatio = 0.75;
    double failureToleranceRatio = 0.4;
    boolean assumeFailure = false;

    private double calcAverage() {
        double average = 0.0;
        for (double d : this.list) {
            average += d;
        }
        if (this.list.size() > 0) {
            average /= (double)this.list.size();
        }
        return average;
    }

    private double calcAverage2() {
        double average = 0.0;
        double steepnes = 0.0;
        double first = this.list.get(0);
        for (int i = 1; i < this.list.size(); ++i) {
            steepnes += (this.list.get(i) - first) / (double)i;
        }
        steepnes /= (double)(this.list.size() - 1);
        for (double d : this.list) {
            average += d;
        }
        if (this.list.size() > 0) {
            average /= (double)this.list.size();
        }
        return average + steepnes / 2.0;
    }

    public double goodVal(double newOne) {
        boolean remove = false;
        if (this.assumeFailure) {
            double last = this.list.get(this.list.size() - 1);
            if (Math.abs(newOne - last) > this.failureToleranceRatio * last) {
                remove = true;
            }
            if ((newOne - last) * Math.signum(last) > 0.0) {
                remove = false;
            }
            if (remove) {
                this.list.remove(this.list.size() - 1);
            }
        }
        double average = this.calcAverage();
        double tolerance = Math.abs(this.CriticalRatio * average);
        this.list.add(newOne);
        if (this.list.size() == 5) {
            this.list.remove(0);
        }
        double result = average;
        this.assumeFailure = true;
        if (Math.abs(Math.abs(average) - Math.abs(newOne)) < tolerance) {
            this.assumeFailure = false;
            result = newOne;
        }
        if (newOne == 0.0) {
            this.assumeFailure = true;
            result = average;
        }
        if (this.assumeFailure & !remove) {
            this.assumeFailure = false;
            result = newOne;
        }
        return result;
    }

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double val = context.getAxisState(this.inSlot).doubleValue();
        val = this.goodVal(val);
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(val));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
    }

    public void dispose() {
    }

    public String getName() {
        return "BumpAxis";
    }
}

