/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.Rn;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualProductMatrix
implements VirtualDevice {
    InputSlot leftSlot;
    InputSlot rightSlot;
    InputSlot productSlot;
    double[] product = new double[16];
    double[] matrixL = new double[16];
    double[] matrixR = new double[16];

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        try {
            DoubleArray matrixLeft = context.getTransformationMatrix(this.leftSlot);
            this.matrixL = matrixLeft.toDoubleArray(this.matrixL);
        }
        catch (NullPointerException npe) {
            throw new MissingSlotException(this.leftSlot);
        }
        try {
            DoubleArray matrixRight = context.getTransformationMatrix(this.rightSlot);
            this.matrixR = matrixRight.toDoubleArray(this.matrixR);
        }
        catch (NullPointerException npe) {
            throw new MissingSlotException(this.rightSlot);
        }
        this.product = Rn.times(this.product, this.matrixL, this.matrixR);
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.productSlot, new DoubleArray(this.product));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.productSlot = result;
        this.leftSlot = (InputSlot)inputSlots.get(0);
        this.rightSlot = (InputSlot)inputSlots.get(1);
    }

    public void dispose() {
    }

    public String getName() {
        return "ProductMatrix";
    }

    public String toString() {
        return "VirtualDevice: " + this.getName();
    }
}

