/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import de.jreality.util.LoggingSystem;
import java.util.List;
import java.util.Map;

public class VirtualPortalRotation
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    double oldAxis;
    boolean isFirst = true;
    double[] slotValue = new double[16];
    DoubleArray outTrafo = new DoubleArray(this.slotValue);
    MatrixBuilder mb = MatrixBuilder.euclidean();
    double gain = 1.0;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        try {
            if (!context.getAxisState(this.inSlot).isReleased()) {
                this.mb.reset().rotateY(this.gain * context.getAxisState(this.inSlot).doubleValue()).assignTo(this.slotValue);
                return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, this.outTrafo);
            }
        }
        catch (Exception e) {
            throw new MissingSlotException(this.inSlot);
        }
        return null;
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        try {
            this.gain = (Double)configuration.get("gain");
        }
        catch (NumberFormatException nfe) {
            LoggingSystem.getLogger(this).warning("unsupported config string");
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "DeltaTrafo";
    }
}

