/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDeviceContext;
import de.jreality.toolsystem.virtual.VirtualRawMousePointerTrafo;

public class VirtualMousePointerTrafo
extends VirtualRawMousePointerTrafo {
    public ToolEvent process(VirtualDeviceContext context) {
        int i;
        ToolEvent te = super.process(context);
        for (i = 0; i < 4; ++i) {
            if (!(Math.abs(this.pointerTrafo[12 + i]) > 1.0E-7)) continue;
            this.scaleColumn(this.pointerTrafo, i, 1.0 / this.pointerTrafo[i + 12]);
        }
        for (i = 0; i < 3; ++i) {
            this.columnTrafo(this.pointerTrafo, i, 3, -1.0);
        }
        double nrm = this.columnNorm(this.pointerTrafo, 2);
        if (nrm > 1.0E-7) {
            this.scaleColumn(this.pointerTrafo, 2, -1.0 / nrm);
        }
        for (int i2 = 1; i2 >= 0; --i2) {
            this.columnTrafo(this.pointerTrafo, i2, i2 + 1, -this.scalarColumnProduct(this.pointerTrafo, i2, i2 + 1));
        }
        this.columnTrafo(this.pointerTrafo, 1, 2, -this.scalarColumnProduct(this.pointerTrafo, 1, 2));
        nrm = this.columnNorm(this.pointerTrafo, 1);
        if (nrm > 1.0E-7) {
            this.scaleColumn(this.pointerTrafo, 1, 1.0 / nrm);
        }
        this.columnTrafo(this.pointerTrafo, 0, 2, -this.scalarColumnProduct(this.pointerTrafo, 0, 2));
        this.columnTrafo(this.pointerTrafo, 0, 1, -this.scalarColumnProduct(this.pointerTrafo, 0, 1));
        nrm = this.columnNorm(this.pointerTrafo, 0);
        if (nrm > 1.0E-7) {
            this.scaleColumn(this.pointerTrafo, 0, 1.0 / nrm);
        }
        this.pointerTrafo[14] = 0.0;
        this.pointerTrafo[13] = 0.0;
        this.pointerTrafo[12] = 0.0;
        this.pointerTrafo[15] = 1.0;
        return te;
    }

    public String getName() {
        return "MousePointerTrafo";
    }

    private void scaleColumn(double[] matrix, int col, double factor) {
        int n = col;
        matrix[n] = matrix[n] * factor;
        int n2 = col + 4;
        matrix[n2] = matrix[n2] * factor;
        int n3 = col + 8;
        matrix[n3] = matrix[n3] * factor;
        int n4 = col + 12;
        matrix[n4] = matrix[n4] * factor;
    }

    private void columnTrafo(double[] matrix, int i, int j, double factor) {
        int n = i;
        matrix[n] = matrix[n] + matrix[j] * factor;
        int n2 = i + 4;
        matrix[n2] = matrix[n2] + matrix[j + 4] * factor;
        int n3 = i + 8;
        matrix[n3] = matrix[n3] + matrix[j + 8] * factor;
        int n4 = i + 12;
        matrix[n4] = matrix[n4] + matrix[j + 12] * factor;
    }

    private double scalarColumnProduct(double[] matrix, int i, int j) {
        return matrix[i] * matrix[j] + matrix[i + 4] * matrix[j + 4] + matrix[i + 8] * matrix[j + 8] + matrix[i + 12] * matrix[j + 12];
    }

    private double columnNorm(double[] matrix, int i) {
        return Math.sqrt(this.scalarColumnProduct(matrix, i, i));
    }
}

