/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.math.Rn;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualInvertMatrix
implements VirtualDevice {
    InputSlot outSlot;
    InputSlot matrixIn;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        DoubleArray matrixDAA = context.getTransformationMatrix(this.matrixIn);
        double[] matrix = matrixDAA.toDoubleArray(null);
        if (this.matrixIn == InputSlot.getDevice("CameraToNDC")) {
            // empty if block
        }
        double[] inverse = Rn.inverse(null, matrix);
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new DoubleArray(inverse));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.outSlot = result;
        this.matrixIn = (InputSlot)inputSlots.get(0);
    }

    public void dispose() {
    }

    public String getName() {
        return "InvertMatrix";
    }

    public String toString() {
        return "VirtualDevice: " + this.getName();
    }
}

