/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.List;
import java.util.Map;

public class VirtualExtractAxis
implements VirtualDevice {
    InputSlot inSlot;
    InputSlot outSlot;
    private int index = -1;
    double maxVal = 1.0;
    AxisState state;
    double lastVal = Double.MAX_VALUE;
    double gain = 1.0;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        double newVal;
        if (this.index == -1) {
            return null;
        }
        this.lastVal = newVal = this.gain * context.getTransformationMatrix(this.inSlot).getValueAt(this.index);
        return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.outSlot, new AxisState(newVal));
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlot = (InputSlot)inputSlots.get(0);
        this.outSlot = result;
        try {
            if (configuration != null && configuration.get("gain") != null) {
                this.gain = (Double)configuration.get("gain");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (configuration.get("axis").equals("translationX")) {
            this.index = 3;
            return;
        }
        if (configuration.get("axis").equals("translationY")) {
            this.index = 7;
            return;
        }
        if (configuration.get("axis").equals("translationZ")) {
            this.index = 11;
            return;
        }
        try {
            this.index = (Integer)configuration.get("index");
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("unsupported config string");
        }
    }

    public void dispose() {
    }

    public String getName() {
        return "ExtractAxis";
    }
}

