/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.virtual;

import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.MissingSlotException;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.toolsystem.VirtualDeviceContext;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VirtualCoupledAxis
implements VirtualDevice {
    List<InputSlot> inSlots;
    InputSlot out;
    boolean currentState;
    boolean initialized;

    public ToolEvent process(VirtualDeviceContext context) throws MissingSlotException {
        if (!this.initialized) {
            this.initialized = true;
            return new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.out, AxisState.ORIGIN);
        }
        boolean state = true;
        for (InputSlot inSlot : this.inSlots) {
            if (state = state && context.getAxisState(inSlot).isPressed()) continue;
            break;
        }
        if (state != this.currentState) {
            this.currentState = state;
            ToolEvent te = new ToolEvent(context.getEvent().getSource(), context.getEvent().getTimeStamp(), this.out, this.currentState ? AxisState.PRESSED : AxisState.ORIGIN);
            if (context.getEvent().getInputSlot() == this.inSlots.get(0) || context.getAxisState(this.inSlots.get(0)).isPressed()) {
                context.getEvent().consume();
            }
            return te;
        }
        return null;
    }

    public void initialize(List inputSlots, InputSlot result, Map configuration) {
        this.inSlots = new LinkedList<InputSlot>(inputSlots);
        this.out = result;
    }

    public void dispose() {
    }

    public String getName() {
        return "CoupledAxis";
    }

    public String toString() {
        return "Virtual Device: " + this.getName();
    }
}

