/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.scene.Viewer;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.toolsystem.util.OSCPool;
import de.sciss.net.OSCListener;
import de.sciss.net.OSCMessage;
import de.sciss.net.OSCServer;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinuxOptimusMiniDevice
implements RawDevice,
OSCListener {
    private OSCServer osc;
    private ToolEventQueue queue;
    private InputSlot[] keySlots = new InputSlot[3];

    @Override
    public void dispose() {
        this.osc.removeOSCListener((OSCListener)this);
    }

    @Override
    public String getName() {
        return "Optimus Mini";
    }

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        try {
            Object co;
            int port = 11223;
            if (config.containsKey("port") && (co = config.get("port")) instanceof Integer) {
                port = (Integer)co;
            }
            this.osc = OSCPool.getUDPServer(port);
            this.osc.addOSCListener((OSCListener)this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        int id = -1;
        if (rawDeviceName.equals("Key1")) {
            id = 0;
        }
        if (rawDeviceName.equals("Key2")) {
            id = 1;
        }
        if (rawDeviceName.equals("Key3")) {
            id = 2;
        }
        if (id == -1) {
            throw new IllegalArgumentException("No such key: " + rawDeviceName);
        }
        this.keySlots[id] = inputDevice;
        return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    public void buttonPressed(int buttonID) {
        if (buttonID < 1 || buttonID > 3) {
            System.out.println("ILLEGAL BUTTON ID: " + buttonID);
            return;
        }
        InputSlot inputDevice = this.keySlots[buttonID - 1];
        long ct = System.currentTimeMillis();
        ToolEvent press = new ToolEvent((Object)this, ct, inputDevice, AxisState.PRESSED);
        ToolEvent release = new ToolEvent((Object)this, ct + 1L, inputDevice, AxisState.ORIGIN);
        this.queue.addEvent(press);
        this.queue.addEvent(release);
    }

    public void messageReceived(OSCMessage msg, SocketAddress addr, long time) {
        this.buttonPressed((Integer)msg.getArg(0));
    }
}

