/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.scene.Viewer;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.PollingDevice;
import de.jreality.toolsystem.raw.RawDevice;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceSystemTimer
implements RawDevice,
PollingDevice {
    private ToolEventQueue queue;
    String myDeviceName = "tick";
    private InputSlot device;
    long lastEvent = -1L;

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        if (!rawDeviceName.equals(this.myDeviceName)) {
            throw new IllegalArgumentException("no such raw axis");
        }
        this.device = inputDevice;
        return new MyToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    @Override
    public synchronized void poll() {
        if (this.queue == null) {
            return;
        }
        long ct = System.currentTimeMillis();
        int delta = (int)(this.lastEvent == -1L ? 0L : ct - this.lastEvent);
        this.lastEvent = ct;
        MyToolEvent e = new MyToolEvent((Object)this, ct, this.device, new AxisState(delta));
        this.queue.addEvent(e);
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
    }

    @Override
    public String getName() {
        return "SystemTimer";
    }

    public String toString() {
        return "RawDevice: SystemTimer";
    }

    static class MyToolEvent
    extends ToolEvent {
        private static final long serialVersionUID = -1752817756822635827L;

        public MyToolEvent(Object source, long when, InputSlot device, AxisState axis) {
            super(source, when, device, axis);
        }

        protected boolean compareAxisStates(AxisState axis1, AxisState axis2) {
            return true;
        }

        protected void replaceWith(ToolEvent replacement) {
            this.axis = new AxisState(replacement.getAxisState().intValue() + this.getAxisState().intValue());
            this.time = replacement.getTimeStamp();
        }
    }
}

