/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.scene.Viewer;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.LoggingSystem;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceOldKeyboard
implements RawDevice,
KeyListener {
    private HashMap keysToVirtual = new HashMap();
    private ToolEventQueue queue;
    private Component component;
    HashMap lastReleased = new HashMap();
    HashSet cancelEvents = new HashSet();
    HashSet seenReleases = new HashSet();

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        if (!viewer.hasViewingComponent() || !(viewer.getViewingComponent() instanceof Component)) {
            throw new UnsupportedOperationException("need AWT component");
        }
        this.component = (Component)viewer.getViewingComponent();
        this.component.addKeyListener(this);
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        InputSlot id = (InputSlot)this.keysToVirtual.get(new Integer(e.getKeyCode()));
        if (id != null) {
            Long timestamp = new Long(e.getWhen());
            if (((HashMap)this.lastReleased.get(id)).containsKey(timestamp)) {
                KeyEvent releaseEvent = (KeyEvent)((HashMap)this.lastReleased.get(id)).get(timestamp);
                this.cancelEvents.add(releaseEvent);
                return;
            }
            timestamp = new Long(e.getWhen() - 1L);
            if (((HashMap)this.lastReleased.get(id)).containsKey(timestamp)) {
                KeyEvent releaseEvent = (KeyEvent)((HashMap)this.lastReleased.get(id)).get(timestamp);
                this.cancelEvents.add(releaseEvent);
                return;
            }
            ToolEvent ev = new ToolEvent((Object)this, System.currentTimeMillis(), id, AxisState.PRESSED);
            this.queue.addEvent(ev);
            LoggingSystem.getLogger(this).fine(this.hashCode() + " added key pressed [" + id + "] " + e.getWhen());
        }
    }

    @Override
    public synchronized void keyReleased(final KeyEvent e) {
        InputSlot id = (InputSlot)this.keysToVirtual.get(new Integer(e.getKeyCode()));
        if (id != null) {
            if (!this.seenReleases.contains(e)) {
                LoggingSystem.getLogger(this).log(Level.FINEST, "release first");
                this.seenReleases.add(e);
                ((HashMap)this.lastReleased.get(id)).put(new Long(e.getWhen()), e);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        DeviceOldKeyboard.this.keyReleased(e);
                    }
                });
            } else {
                LoggingSystem.getLogger(this).log(Level.FINEST, "release second");
                if (this.cancelEvents.contains(e)) {
                    this.cancelEvents.remove(id);
                } else {
                    this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), id, AxisState.ORIGIN));
                    LoggingSystem.getLogger(this).finer("added key released [" + id + "] " + e.getWhen());
                }
                ((HashMap)this.lastReleased.get(id)).remove(new Long(e.getWhen()));
            }
        }
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        this.keysToVirtual.put(this.resolveKeyCode(rawDeviceName), inputDevice);
        this.lastReleased.put(inputDevice, new HashMap());
        return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    private Integer resolveKeyCode(String fieldName) {
        try {
            int val = KeyEvent.class.getField(fieldName).getInt(KeyEvent.class);
            return new Integer(val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("no such key " + fieldName);
        }
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    @Override
    public void dispose() {
        this.component.removeKeyListener(this);
    }

    @Override
    public String getName() {
        return "Keyboard";
    }

    public String toString() {
        return "RawDevice: Keyboard";
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

