/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.math.Matrix;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.raw.AbstractDeviceMouse;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.LoggingSystem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceMouse
extends AbstractDeviceMouse
implements RawDevice,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private static int MOUSE_GRAB_TOGGLE = 121;
    private static int MOUSE_GRAB_TOGGLE_ALTERNATIVE = 67;
    private Component component;
    Cursor emptyCursor;
    private ComponentListener componentListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent e) {
            if (DeviceMouse.this.isCenter()) {
                DeviceMouse.this.setCenter(false);
                DeviceMouse.this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), InputSlot.getDevice("LookSwitch"), AxisState.PRESSED, null));
                DeviceMouse.this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), InputSlot.getDevice("LookSwitch"), AxisState.ORIGIN, null));
            }
            DeviceMouse.this.requestFocus();
        }
    };
    private KeyListener keyListener = new KeyListener(){

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == MOUSE_GRAB_TOGGLE || e.getKeyCode() == MOUSE_GRAB_TOGGLE_ALTERNATIVE && e.isShiftDown() && e.isControlDown()) {
                DeviceMouse.this.setCenter(!DeviceMouse.this.isCenter());
                DeviceMouse.this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), InputSlot.getDevice("LookSwitch"), AxisState.PRESSED, null));
                DeviceMouse.this.queue.addEvent(new ToolEvent(this, System.currentTimeMillis(), InputSlot.getDevice("LookSwitch"), AxisState.ORIGIN, null));
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        InputSlot button = this.findButton(e);
        if (button != null) {
            this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), button, AxisState.PRESSED));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        InputSlot button = this.findButton(e);
        if (button != null) {
            this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), button, AxisState.ORIGIN));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMoved(e.getX(), e.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int i;
        InputSlot slot;
        int count = e.getWheelRotation();
        if (count > 0) {
            slot = (InputSlot)this.usedSources.get("wheel_up");
            if (slot == null) {
                return;
            }
            for (i = 0; i < count; ++i) {
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.PRESSED));
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.ORIGIN));
            }
        }
        if (count < 0) {
            slot = (InputSlot)this.usedSources.get("wheel_down");
            if (slot == null) {
                return;
            }
            for (i = 0; i > count; --i) {
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.PRESSED));
                this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), slot, AxisState.ORIGIN));
            }
        }
    }

    public static int getRealButton(MouseEvent e) {
        int button = e.getButton();
        if (button == 0) {
            int mods = e.getModifiersEx();
            button = (mods & 0x400) != 0 ? 1 : ((mods & 0x800) != 0 ? 2 : 3);
        } else {
            int mods = e.getModifiers();
            if (e.isAltDown() && (mods & 8) != 0) {
                button = 2;
            } else if (button == 1 && (mods & 4) != 0) {
                button = 3;
            }
        }
        return button;
    }

    private InputSlot findButton(MouseEvent e) {
        int button = DeviceMouse.getRealButton(e);
        if (button == 1) {
            return (InputSlot)this.usedSources.get("left");
        }
        if (button == 3) {
            return (InputSlot)this.usedSources.get("right");
        }
        if (button == 2) {
            return (InputSlot)this.usedSources.get("center");
        }
        return null;
    }

    public void setComponent(Component component) {
        this.component = component;
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        component.addMouseWheelListener(this);
        component.addComponentListener(this.componentListener);
        component.addKeyListener(this.keyListener);
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        if (!knownSources.contains(rawDeviceName)) {
            throw new IllegalArgumentException("no such raw device");
        }
        this.usedSources.put(rawDeviceName, inputDevice);
        if (rawDeviceName.equals("axes")) {
            return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, new DoubleArray(new Matrix().getArray()));
        }
        if (rawDeviceName.equals("axesEvolution")) {
            Matrix initM = new Matrix();
            initM.setEntry(2, 3, -1.0);
            return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, new DoubleArray(initM.getArray()));
        }
        return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    @Override
    public void dispose() {
        this.component.removeMouseListener(this);
        this.component.removeMouseMotionListener(this);
        this.component.removeMouseWheelListener(this);
        this.component.removeComponentListener(this.componentListener);
        this.component.removeKeyListener(this.keyListener);
    }

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        if (!viewer.hasViewingComponent() || !(viewer.getViewingComponent() instanceof Component)) {
            throw new UnsupportedOperationException("need AWT component");
        }
        this.setComponent((Component)viewer.getViewingComponent());
    }

    @Override
    public String getName() {
        return "Mouse";
    }

    public String toString() {
        return "RawDevice: Mouse AWT";
    }

    @Override
    public void installGrabs() {
        try {
            if (this.emptyCursor == null) {
                ImageIcon emptyIcon = new ImageIcon(new byte[0]);
                this.emptyCursor = this.component.getToolkit().createCustomCursor(emptyIcon.getImage(), new Point(0, 0), "emptyCursor");
            }
            this.component.setCursor(this.emptyCursor);
            this.requestFocus();
        }
        catch (Exception e) {
            LoggingSystem.getLogger(this).log(Level.WARNING, "cannot grab mouse", e);
        }
    }

    @Override
    public void uninstallGrabs() {
        try {
            this.component.setCursor(Cursor.getPredefinedCursor(0));
            this.requestFocus();
        }
        catch (Exception e) {
            LoggingSystem.getLogger(this).log(Level.WARNING, "cannot grab mouse", e);
        }
    }

    private void requestFocus() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        boolean fow = this.component.requestFocusInWindow();
    }

    @Override
    protected int getWidth() {
        return this.component.getWidth();
    }

    @Override
    protected int getHeight() {
        return this.component.getHeight();
    }

    @Override
    protected void calculateCenter() {
        this.winCenterX = this.getWidth() / 2;
        this.winCenterY = this.getHeight() / 2;
        for (Component currentCmp = this.component; currentCmp != null; currentCmp = currentCmp.getParent()) {
            if (currentCmp instanceof Container) {
                Insets insets = ((Container)currentCmp).getInsets();
                this.winCenterX += insets.left;
                this.winCenterY += insets.top;
            }
            this.winCenterX += currentCmp.getX();
            this.winCenterY += currentCmp.getY();
        }
    }
}

