/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.raw;

import de.jreality.scene.Viewer;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.raw.PollingDevice;
import de.jreality.toolsystem.raw.RawDevice;
import de.jreality.util.LoggingSystem;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceKeyboard
implements RawDevice,
KeyListener,
AWTEventListener,
PollingDevice {
    private HashMap<Integer, Boolean> keyState = new HashMap();
    private HashMap<Integer, InputSlot> keysToVirtual = new HashMap();
    private ToolEventQueue queue;
    private Component component;
    private LinkedList<KeyEvent> myQueue = new LinkedList();
    AWTEvent last = null;
    boolean hasFocus = false;

    @Override
    public void initialize(Viewer viewer, Map<String, Object> config) {
        if (!viewer.hasViewingComponent() || !(viewer.getViewingComponent() instanceof Component)) {
            throw new UnsupportedOperationException("need AWT component");
        }
        this.component = (Component)viewer.getViewingComponent();
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        }
        catch (SecurityException e) {
            this.component.addKeyListener(this);
            LoggingSystem.getLogger(this).info("Couldn't create AWTEventListener, using KeyListener instead");
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        InputSlot id = this.keysToVirtual.get(e.getKeyCode());
        if (id != null) {
            this.handleEvent(e);
            LoggingSystem.getLogger(this).fine(this.hashCode() + " added key pressed [" + id + "] " + e.getWhen());
        }
    }

    private synchronized void handleEvent(KeyEvent ev) {
        if (ev.getID() == 402) {
            try {
                Thread.sleep(3L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.myQueue.addLast(ev);
        } else if (this.myQueue.size() == 0) {
            this.myQueue.addLast(ev);
        } else if (ev.getWhen() - this.myQueue.getLast().getWhen() < 2L) {
            this.myQueue.removeLast();
        } else {
            this.myQueue.addLast(ev);
        }
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
        InputSlot id = this.keysToVirtual.get(e.getKeyCode());
        if (id != null) {
            this.handleEvent(e);
            LoggingSystem.getLogger(this).finer("added key released [" + id + "] " + e.getWhen());
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public ToolEvent mapRawDevice(String rawDeviceName, InputSlot inputDevice) {
        this.keysToVirtual.put(this.resolveKeyCode(rawDeviceName), inputDevice);
        return new ToolEvent((Object)this, System.currentTimeMillis(), inputDevice, AxisState.ORIGIN);
    }

    private int resolveKeyCode(String fieldName) {
        try {
            int val = KeyEvent.class.getField(fieldName).getInt(KeyEvent.class);
            return val;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("no such key " + fieldName);
        }
    }

    @Override
    public void setEventQueue(ToolEventQueue queue) {
        this.queue = queue;
    }

    @Override
    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    @Override
    public String getName() {
        return "Keyboard";
    }

    public String toString() {
        return "RawDevice: Keyboard";
    }

    @Override
    public synchronized void poll() {
        long ct = System.currentTimeMillis();
        while (!this.myQueue.isEmpty()) {
            KeyEvent next;
            boolean pressed;
            long dt = ct - this.myQueue.getFirst().getWhen();
            if (dt < 3L) {
                return;
            }
            KeyEvent ev = this.myQueue.removeFirst();
            boolean bl = pressed = ev.getID() == 401;
            if (!pressed && (next = (KeyEvent)Toolkit.getDefaultToolkit().getSystemEventQueue().peekEvent(401)) != null && next.getKeyCode() == ev.getKeyCode() && next.getWhen() - ev.getWhen() < 2L) {
                next.consume();
                continue;
            }
            if (this.keyState.get(ev.getKeyCode()) == Boolean.valueOf(pressed)) continue;
            AxisState state = pressed ? AxisState.PRESSED : AxisState.ORIGIN;
            ToolEvent event = new ToolEvent((Object)ev, System.currentTimeMillis(), this.keysToVirtual.get(ev.getKeyCode()), state);
            this.keyState.put(ev.getKeyCode(), pressed);
            this.queue.addEvent(event);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        if (event == this.last) {
            return;
        }
        this.last = event;
        if (event instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)event;
            switch (event.getID()) {
                case 401: {
                    this.checkFocus();
                    if (!this.hasFocus) break;
                    this.keyPressed(e);
                    break;
                }
                case 402: {
                    this.checkModifiers(e);
                    this.keyReleased(e);
                }
            }
        } else {
            switch (event.getID()) {
                case 500: 
                case 504: 
                case 505: {
                    return;
                }
            }
            this.checkModifiers((InputEvent)event);
        }
    }

    private void checkModifiers(InputEvent e) {
        KeyEvent ke;
        int keyCode;
        if (!e.isShiftDown()) {
            keyCode = 16;
            if (e instanceof KeyEvent) {
                ke = (KeyEvent)e;
                if (ke.getKeyCode() != keyCode) {
                    this.checkModifier(keyCode);
                }
            } else {
                this.checkModifier(keyCode);
            }
        }
        if (!e.isControlDown()) {
            keyCode = 17;
            if (e instanceof KeyEvent) {
                ke = (KeyEvent)e;
                if (ke.getKeyCode() != keyCode) {
                    this.checkModifier(keyCode);
                }
            } else {
                this.checkModifier(keyCode);
            }
        }
        if (!e.isAltDown()) {
            keyCode = 18;
            if (e instanceof KeyEvent) {
                ke = (KeyEvent)e;
                if (ke.getKeyCode() != keyCode) {
                    this.checkModifier(keyCode);
                }
            } else {
                this.checkModifier(keyCode);
            }
        }
        if (!e.isAltGraphDown()) {
            keyCode = 65406;
            if (e instanceof KeyEvent) {
                ke = (KeyEvent)e;
                if (ke.getKeyCode() != keyCode) {
                    this.checkModifier(keyCode);
                }
            } else {
                this.checkModifier(keyCode);
            }
        }
        if (!e.isMetaDown()) {
            keyCode = 157;
            if (e instanceof KeyEvent) {
                ke = (KeyEvent)e;
                if (ke.getKeyCode() != keyCode) {
                    this.checkModifier(keyCode);
                }
            } else {
                this.checkModifier(keyCode);
            }
        }
    }

    private void checkModifier(int keyCode) {
        InputSlot modKey = this.keysToVirtual.get(keyCode);
        if (modKey != null && this.keyState.get(keyCode) == Boolean.TRUE) {
            this.queue.addEvent(new ToolEvent((Object)this, System.currentTimeMillis(), modKey, AxisState.ORIGIN));
            this.keyState.put(keyCode, Boolean.FALSE);
            System.out.println("added missing mod key released!");
        }
    }

    private void checkFocus() {
        this.hasFocus = false;
        if (this.component instanceof Container) {
            this.checkFocus((Container)this.component);
        } else {
            this.hasFocus = this.component.isFocusOwner();
        }
    }

    private void checkFocus(Container cc) {
        for (Component c : cc.getComponents()) {
            if (c instanceof Container) {
                this.checkFocus((Container)c);
            }
            if (!c.isFocusOwner()) continue;
            this.hasFocus = true;
        }
    }
}

