/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.config;

import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.VirtualDevice;
import de.jreality.util.LoggingSystem;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class VirtualDeviceConfig {
    static final PersistenceDelegate DELEGATE = new DefaultPersistenceDelegate(new String[]{"virtualDevice", "outSlot", "inSlots", "config"});
    private String virtualDevice;
    private InputSlot outSlot;
    private List inSlots;
    private Map config;

    public Map getConfig() {
        return this.config;
    }

    public List getInSlots() {
        return this.inSlots;
    }

    public InputSlot getOutSlot() {
        return this.outSlot;
    }

    public String getVirtualDevice() {
        return this.virtualDevice;
    }

    public VirtualDeviceConfig(String virtualDevice, InputSlot outSlot, List inSlots, Map config, String mapped) {
        this.virtualDevice = virtualDevice;
        this.outSlot = outSlot;
        this.inSlots = inSlots;
        this.config = config;
    }

    public VirtualDevice createDevice() throws InstantiationException {
        try {
            VirtualDevice ret = (VirtualDevice)Class.forName(this.virtualDevice).newInstance();
            ret.initialize(this.inSlots, this.outSlot, this.config);
            return ret;
        }
        catch (Throwable t) {
            LoggingSystem.getLogger(this).log(Level.CONFIG, "cannot create virtual device", t);
            throw new InstantiationException("cannot create raw device:" + this.virtualDevice);
        }
    }

    public String toString() {
        return "VirtualDeviceConfig: " + (this.virtualDevice != null ? this.virtualDevice : "null") + " outSlot=" + this.outSlot + " inslots=" + this.inSlots.toString() + " config=" + this.config.toString();
    }
}

