/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.config;

import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import java.beans.DefaultPersistenceDelegate;
import java.beans.PersistenceDelegate;

public class VirtualConstant {
    public static final PersistenceDelegate DELEGATE = new DefaultPersistenceDelegate(new String[]{"slot", "value"});
    private InputSlot slot;
    private double[] trafo;
    private Double axis;
    private boolean isTrafo;

    public VirtualConstant(InputSlot slot, Object value) {
        this.slot = slot;
        if (value instanceof Double) {
            this.axis = (Double)value;
        } else {
            this.trafo = (double[])value;
            if (this.trafo.length != 16) {
                throw new IllegalArgumentException("no 4x4 matrix");
            }
            this.isTrafo = true;
        }
    }

    public InputSlot getSlot() {
        return this.slot;
    }

    public boolean isTrafo() {
        return this.isTrafo;
    }

    public AxisState getAxisState() {
        if (this.isTrafo) {
            return null;
        }
        return new AxisState(this.axis);
    }

    public DoubleArray getTransformationMatrix() {
        if (!this.isTrafo) {
            return null;
        }
        return new DoubleArray(this.trafo);
    }

    public String toString() {
        return "VirtualConstant: " + this.slot + "->" + (this.isTrafo ? new DoubleArray(this.trafo).toString() : new AxisState(this.axis).toString());
    }
}

