/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem.config;

import de.jreality.toolsystem.config.RawDeviceConfig;
import de.jreality.toolsystem.config.RawMapping;
import de.jreality.toolsystem.config.VirtualConstant;
import de.jreality.toolsystem.config.VirtualDeviceConfig;
import de.jreality.toolsystem.config.VirtualMapping;
import de.jreality.util.Input;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSystemConfiguration {
    private static final String DEFAULT_TOOLCONFIG = "toolconfig.xml";
    private List<RawDeviceConfig> rawConfigs = new LinkedList<RawDeviceConfig>();
    private List<RawMapping> rawMappings = new LinkedList<RawMapping>();
    private List<VirtualDeviceConfig> virtualConfigs = new LinkedList<VirtualDeviceConfig>();
    private List<VirtualMapping> virtualMappings = new LinkedList<VirtualMapping>();
    private List<VirtualConstant> virtualConstants = new LinkedList<VirtualConstant>();

    public static ToolSystemConfiguration loadDefaultConfiguration() {
        try {
            URL toolconfig = ToolSystemConfiguration.class.getResource(DEFAULT_TOOLCONFIG);
            if (toolconfig == null) {
                String text = "Resource \"toolconfig.xml\" not found.\n Expected in " + ToolSystemConfiguration.class.getPackage().toString() + ".\n This is often caused by Eclipse when Preferences->Java->Building->Filtered Resources includes \"*.xml\".";
                System.err.println(text);
                throw new RuntimeException(text);
            }
            return ToolSystemConfiguration.loadConfiguration(Input.getInput(toolconfig));
        }
        catch (IOException e) {
            throw new Error();
        }
    }

    public static ToolSystemConfiguration loadDefaultDesktopAndPortalConfiguration() throws IOException {
        LinkedList<ToolSystemConfiguration> all = new LinkedList<ToolSystemConfiguration>();
        all.add(ToolSystemConfiguration.loadDefaultPortalConfiguration());
        all.add(ToolSystemConfiguration.loadDefaultDesktopConfiguration());
        return ToolSystemConfiguration.merge(all);
    }

    public static ToolSystemConfiguration loadDefaultDesktopConfiguration() throws IOException {
        return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource(DEFAULT_TOOLCONFIG)));
    }

    public static ToolSystemConfiguration loadDefaultDesktopSwtConfiguration() throws IOException {
        return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig_swt.xml")));
    }

    public static ToolSystemConfiguration loadDefaultDesktopConfiguration(List<Input> additionalInputs) throws IOException {
        if (additionalInputs.isEmpty()) {
            return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource(DEFAULT_TOOLCONFIG)));
        }
        LinkedList<ToolSystemConfiguration> all = new LinkedList<ToolSystemConfiguration>();
        all.add(ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource(DEFAULT_TOOLCONFIG))));
        all.add(ToolSystemConfiguration.loadConfiguration(additionalInputs));
        return ToolSystemConfiguration.merge(all);
    }

    public static ToolSystemConfiguration loadDefaultPortalConfiguration() throws IOException {
        return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig-portal.xml")));
    }

    public static ToolSystemConfiguration loadRemotePortalConfiguration() throws IOException {
        return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig-portal-remote.xml")));
    }

    public static ToolSystemConfiguration loadRemotePortalMasterConfiguration() throws IOException {
        return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig-portal-remote-master.xml")));
    }

    public static ToolSystemConfiguration loadDefaultPortalConfiguration(List<Input> additionalInputs) throws IOException {
        if (additionalInputs.isEmpty()) {
            return ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig-portal.xml")));
        }
        LinkedList<ToolSystemConfiguration> all = new LinkedList<ToolSystemConfiguration>();
        all.add(ToolSystemConfiguration.loadConfiguration(Input.getInput(ToolSystemConfiguration.class.getResource(DEFAULT_TOOLCONFIG))));
        all.add(ToolSystemConfiguration.loadConfiguration(additionalInputs));
        return ToolSystemConfiguration.merge(all);
    }

    public static ToolSystemConfiguration loadConfiguration(Input xmlFile) throws IOException {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        tfactory.setURIResolver(new URIResolver(){

            public Source resolve(String href, String base) throws TransformerException {
                try {
                    URL url = ToolSystemConfiguration.class.getResource(href);
                    Input input = url == null ? Input.getInput(href) : Input.getInput(url);
                    System.out.println("resolved: " + input);
                    return new StreamSource(input.getInputStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
        Input xslt = Input.getInput(ToolSystemConfiguration.class.getResource("toolconfig.xsl"));
        Transformer transformer = null;
        try {
            transformer = tfactory.newTransformer(new StreamSource(xslt.getInputStream()));
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        StreamSource src = new StreamSource(xmlFile.getInputStream());
        DOMResult outResult = null;
        for (int i = 0; i < 5; ++i) {
            if (outResult != null) {
                src = new StreamSource(ToolSystemConfiguration.domToInputStream(outResult.getNode()));
            }
            outResult = new DOMResult();
            try {
                transformer.transform(src, outResult);
                continue;
            }
            catch (TransformerException e1) {
                e1.printStackTrace();
            }
        }
        XMLDecoder dec = new XMLDecoder(ToolSystemConfiguration.domToInputStream(outResult.getNode()), null, new ExceptionListener(){

            public void exceptionThrown(Exception e) {
                e.printStackTrace();
            }
        }, ToolSystemConfiguration.class.getClassLoader());
        ToolSystemConfiguration tsc = (ToolSystemConfiguration)dec.readObject();
        return tsc;
    }

    private static void sysoutXML(DOMResult outResult) {
        StringBuffer sb = new StringBuffer(1024);
        ToolSystemConfiguration.domToString(outResult.getNode(), sb, 0);
        System.out.println(sb.toString());
    }

    public static ToolSystemConfiguration loadConfiguration(List<Input> inputs) throws IOException {
        LinkedList<ToolSystemConfiguration> confs = new LinkedList<ToolSystemConfiguration>();
        for (Input in : inputs) {
            confs.add(ToolSystemConfiguration.loadConfiguration(in));
        }
        return ToolSystemConfiguration.merge(confs);
    }

    private static ToolSystemConfiguration merge(List<ToolSystemConfiguration> list) {
        ToolSystemConfiguration result = new ToolSystemConfiguration();
        for (ToolSystemConfiguration conf : list) {
            result.rawConfigs.addAll(conf.rawConfigs);
            result.rawMappings.addAll(conf.rawMappings);
            result.virtualConfigs.addAll(conf.virtualConfigs);
            result.virtualConstants.addAll(conf.virtualConstants);
            result.virtualMappings.addAll(conf.virtualMappings);
        }
        return result;
    }

    public List<RawDeviceConfig> getRawConfigs() {
        return this.rawConfigs;
    }

    public List<RawMapping> getRawMappings() {
        return this.rawMappings;
    }

    public List<VirtualDeviceConfig> getVirtualConfigs() {
        return this.virtualConfigs;
    }

    public List<VirtualMapping> getVirtualMappings() {
        return this.virtualMappings;
    }

    public List<VirtualConstant> getVirtualConstants() {
        return this.virtualConstants;
    }

    public void setRawConfigs(List<RawDeviceConfig> rawConfigs) {
        this.rawConfigs = rawConfigs;
    }

    public void setRawMappings(List<RawMapping> rawMappings) {
        this.rawMappings = rawMappings;
    }

    public void setVirtualConfigs(List<VirtualDeviceConfig> virtualConfigs) {
        this.virtualConfigs = virtualConfigs;
    }

    public void setVirtualMappings(List<VirtualMapping> virtualMappings) {
        this.virtualMappings = virtualMappings;
    }

    public void setVirtualConstants(List<VirtualConstant> virtualConstants) {
        this.virtualConstants = virtualConstants;
    }

    public void addRawDeviceConfig(RawDeviceConfig config) {
        this.rawConfigs.add(config);
    }

    public void addRawMapping(RawMapping mapping) {
        this.rawMappings.add(mapping);
    }

    public void addVirtualDeviceConfig(VirtualDeviceConfig config) {
        this.virtualConfigs.add(config);
    }

    public void addVirtualMapping(VirtualMapping mapping) {
        this.virtualMappings.add(mapping);
    }

    public void addVirtualConstant(VirtualConstant constant) {
        this.virtualConstants.add(constant);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RawDevices:\n");
        Iterator<Object> i = this.getRawConfigs().iterator();
        while (i.hasNext()) {
            sb.append("\t" + ((Object)i.next()).toString()).append('\n');
        }
        sb.append("\nRawMappings:\n");
        i = this.getRawMappings().iterator();
        while (i.hasNext()) {
            sb.append("\t" + i.next().toString()).append('\n');
        }
        sb.append("\nVirtualDevices:\n");
        i = this.getVirtualConfigs().iterator();
        while (i.hasNext()) {
            sb.append("\t" + i.next().toString()).append('\n');
        }
        sb.append("\nVirtualMappings:\n");
        i = this.getVirtualMappings().iterator();
        while (i.hasNext()) {
            sb.append("\t" + i.next().toString()).append('\n');
        }
        sb.append("\nVirtualConstants:\n");
        i = this.getVirtualConstants().iterator();
        while (i.hasNext()) {
            sb.append("\t" + i.next().toString()).append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    public static InputStream domToInputStream(Node root) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer(1024);
        ToolSystemConfiguration.domToString(root, sb, 0);
        byte[] bytes = sb.toString().getBytes("UTF-8");
        return new ByteArrayInputStream(bytes);
    }

    public static void domToString(Node node, StringBuffer sb, int ind) {
        switch (node.getNodeType()) {
            case 1: {
                String name = node.getNodeName();
                switch (sb.length() > 0 ? (int)sb.charAt(sb.length() - 1) : 10) {
                    case 62: {
                        sb.append('\n');
                    }
                    case 10: {
                        for (int ix = 0; ix < ind; ++ix) {
                            sb.append(' ');
                        }
                        break;
                    }
                }
                sb.append('<').append(name);
                NamedNodeMap attr = node.getAttributes();
                if (attr != null) {
                    int n = attr.getLength();
                    for (int ix = 0; ix < n; ++ix) {
                        Node a = attr.item(ix);
                        if (!((Attr)a).getSpecified()) continue;
                        sb.append(' ').append(a.getNodeName()).append("=\"");
                        ToolSystemConfiguration.quote(a.getNodeValue(), sb);
                        sb.append('\"');
                    }
                }
                if (!node.hasChildNodes()) {
                    sb.append("/>");
                    return;
                }
                sb.append(">");
                int lastPos = sb.length();
                ind += 2;
                for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                    ToolSystemConfiguration.domToString(n, sb, ind);
                }
                ind -= 2;
                if (lastPos < sb.length()) {
                    switch (sb.charAt(sb.length() - 1)) {
                        case '>': {
                            if (sb.charAt(sb.length() - 2) == ']') break;
                            sb.append('\n');
                        }
                        case '\n': {
                            for (int ix = 0; ix < ind; ++ix) {
                                sb.append(' ');
                            }
                            break;
                        }
                    }
                }
                sb.append("</").append(name).append('>');
                break;
            }
            case 3: {
                String text = node.getNodeValue();
                ToolSystemConfiguration.quote(text, sb);
                break;
            }
            case 4: {
                sb.append("<![CDATA[").append(node.getNodeValue()).append("]]>");
                break;
            }
            case 8: {
                sb.append("<!--").append(node.getNodeValue()).append("-->");
                break;
            }
            case 9: {
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
                for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
                    ToolSystemConfiguration.domToString(n, sb, ind);
                }
                break;
            }
            case 10: {
                DocumentType type = (DocumentType)node;
                sb.append("<!DOCTYPE ").append(type.getName()).append(' ');
                String spec = type.getPublicId();
                if (spec != null) {
                    sb.append("PUBLIC \"").append(spec).append('\"');
                }
                if ((spec = type.getSystemId()) != null) {
                    sb.append("SYSTEM \"").append(spec).append('\"');
                }
                sb.append(">\n");
            }
        }
    }

    private static void quote(String text, StringBuffer sb) {
        sb.ensureCapacity(sb.length() + text.length());
        int num = text.length();
        block6: for (int ix = 0; ix < num; ++ix) {
            switch (text.charAt(ix)) {
                default: {
                    sb.append(text.charAt(ix));
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        ToolSystemConfiguration ts = ToolSystemConfiguration.loadDefaultConfiguration();
        System.out.println(ts);
    }
}

