/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.event.ToolEvent;
import de.jreality.scene.event.ToolListener;
import de.jreality.scene.proxy.tree.EntityFactory;
import de.jreality.scene.proxy.tree.SceneGraphNodeEntity;
import de.jreality.scene.proxy.tree.SceneTreeNode;
import de.jreality.scene.proxy.tree.UpToDateSceneProxyBuilder;
import de.jreality.scene.tool.Tool;
import de.jreality.toolsystem.ToolSystem;

public class ToolUpdateProxy {
    private ToolSystem toolSystem;
    private Builder builder;

    public ToolUpdateProxy(ToolSystem ts) {
        this.toolSystem = ts;
    }

    void dispose() {
        if (this.builder != null) {
            this.builder.dispose();
            this.builder = null;
        }
    }

    public void setSceneRoot(SceneGraphComponent comp) {
        if (this.builder != null) {
            throw new IllegalStateException("twice called");
        }
        if (comp == null) {
            return;
        }
        this.builder = new Builder(comp);
        this.builder.createProxyTree();
    }

    private class SceneGraphComponentEntity
    extends SceneGraphNodeEntity
    implements ToolListener {
        private final SceneGraphComponent comp;

        protected SceneGraphComponentEntity(SceneGraphComponent node) {
            super(node);
            this.comp = node;
            this.comp.addToolListener(this);
        }

        protected void addTreeNode(SceneTreeNode tn) {
            super.addTreeNode(tn);
            if (ToolUpdateProxy.this.toolSystem != null) {
                for (Tool tool : this.comp.getTools()) {
                    ToolUpdateProxy.this.toolSystem.addTool(tool, tn.toPath());
                }
            }
        }

        protected void removeTreeNode(SceneTreeNode tn) {
            super.removeTreeNode(tn);
            if (ToolUpdateProxy.this.toolSystem != null) {
                for (Tool tool : this.comp.getTools()) {
                    ToolUpdateProxy.this.toolSystem.removeTool(tool, tn.toPath());
                }
            }
        }

        public void toolAdded(ToolEvent ev) {
            if (ToolUpdateProxy.this.toolSystem != null) {
                for (SceneTreeNode node : this.getTreeNodes()) {
                    ToolUpdateProxy.this.toolSystem.addTool(ev.getTool(), node.toPath());
                }
            }
        }

        public void toolRemoved(ToolEvent ev) {
            if (ToolUpdateProxy.this.toolSystem != null) {
                for (SceneTreeNode node : this.getTreeNodes()) {
                    ToolUpdateProxy.this.toolSystem.removeTool(ev.getTool(), node.toPath());
                }
            }
        }

        protected void dispose() {
            this.comp.removeToolListener(this);
            super.dispose();
        }
    }

    private class Builder
    extends UpToDateSceneProxyBuilder {
        Builder(SceneGraphComponent root) {
            super(root);
            this.setEntityFactory(new EntityFactory(){

                public SceneGraphNodeEntity produceSceneGraphNodeEntity(SceneGraphNode node) {
                    if (node instanceof SceneGraphComponent) {
                        return new SceneGraphComponentEntity((SceneGraphComponent)node);
                    }
                    return super.produceSceneGraphNodeEntity(node);
                }
            });
        }
    }
}

