/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.pick.AABBPickSystem;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.pick.PickSystem;
import de.jreality.scene.pick.PosWHitFilter;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.Tool;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.AnimatorTool;
import de.jreality.toolsystem.DeviceManager;
import de.jreality.toolsystem.SlotManager;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventQueue;
import de.jreality.toolsystem.ToolEventReceiver;
import de.jreality.toolsystem.ToolManager;
import de.jreality.toolsystem.ToolUpdateProxy;
import de.jreality.toolsystem.config.ToolSystemConfiguration;
import de.jreality.util.Input;
import de.jreality.util.LoggingSystem;
import de.jreality.util.RenderTrigger;
import de.jreality.util.Secure;
import de.jreality.util.SystemProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolSystem
implements ToolEventReceiver {
    static WeakHashMap<Viewer, ToolSystem> globalTable = new WeakHashMap();
    private RenderTrigger renderTrigger;
    protected final LinkedList<ToolEvent> compQueue = new LinkedList();
    private final LinkedList<ToolEvent> triggerQueue = new LinkedList();
    private final HashMap<Tool, List<SceneGraphPath>> toolToPath = new HashMap();
    private List<PickResult> pickResults = Collections.emptyList();
    private PosWHitFilter hitFilter;
    private SceneGraphPath emptyPickPath = new SceneGraphPath();
    protected Viewer viewer;
    private ToolContextImpl toolContext;
    protected DeviceManager deviceManager;
    private ToolManager toolManager;
    private SlotManager slotManager;
    private PickSystem pickSystem;
    private ToolUpdateProxy updater;
    private ToolEventQueue eventQueue;
    ToolSystemConfiguration config;
    private PickResult pickResult;
    private static InputSlot pointerSlot = InputSlot.getDevice("PointerTransformation");
    protected boolean executing;
    private final Object KEY = new Object();
    private boolean initialized;
    private MouseOverSupport mouseOverSupport;
    private double[] pointerTrafo = new double[16];
    private double[] currentPointer = new double[16];
    protected final Object mutex = new Object();
    private SceneGraphPath avatarPath;
    private boolean disposed;
    final List<Pair> toolsChanging = new LinkedList<Pair>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolSystem toolSystemForViewer(Viewer v) {
        WeakHashMap<Viewer, ToolSystem> weakHashMap = globalTable;
        synchronized (weakHashMap) {
            ToolSystem sm = globalTable.get(v);
            if (sm != null) {
                return sm;
            }
            LoggingSystem.getLogger(ToolSystem.class).warning("Viewer has no tool system, allocating default");
            sm = new ToolSystem(v, null, null);
            globalTable.put(v, sm);
            return sm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolSystem getToolSystemForViewer(Viewer v) {
        WeakHashMap<Viewer, ToolSystem> weakHashMap = globalTable;
        synchronized (weakHashMap) {
            ToolSystem sm = globalTable.get(v);
            return sm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setToolSystemForViewer(Viewer v, ToolSystem ts) {
        WeakHashMap<Viewer, ToolSystem> weakHashMap = globalTable;
        synchronized (weakHashMap) {
            ToolSystem sm = globalTable.get(v);
            if (sm != null) {
                throw new IllegalStateException("Viewer already has tool system " + sm);
            }
            globalTable.put(v, ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unsetToolSystem(ToolSystem ts) {
        WeakHashMap<Viewer, ToolSystem> weakHashMap = globalTable;
        synchronized (weakHashMap) {
            Iterator<Map.Entry<Viewer, ToolSystem>> it = globalTable.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Viewer, ToolSystem> e = it.next();
                if (e.getValue() != ts) continue;
                it.remove();
            }
        }
    }

    private static ToolSystemConfiguration loadConfiguration() {
        ToolSystemConfiguration config;
        try {
            String toolFile = Secure.getProperty("jreality.toolconfig");
            config = ToolSystemConfiguration.loadConfiguration(Input.getInput(toolFile));
            LoggingSystem.getLogger(ToolSystem.class).config("Using toolconfig=" + toolFile);
        }
        catch (Exception e1) {
            config = ToolSystemConfiguration.loadDefaultConfiguration();
        }
        return config;
    }

    public ToolSystem(Viewer viewer, ToolSystemConfiguration config, RenderTrigger renderTrigger) {
        this.toolContext = new ToolContextImpl();
        this.toolManager = new ToolManager();
        this.eventQueue = new ToolEventQueue(this);
        if (config == null) {
            config = ToolSystem.loadConfiguration();
        }
        this.config = config;
        this.viewer = viewer;
        this.deviceManager = new DeviceManager(config, this.eventQueue, viewer);
        this.slotManager = new SlotManager(config);
        this.updater = new ToolUpdateProxy(this);
        this.renderTrigger = renderTrigger;
        this.setPickSystem(new AABBPickSystem());
        this.emptyPickPath = new SceneGraphPath();
        this.emptyPickPath.push(viewer.getSceneRoot());
    }

    public void initializeSceneTools() {
        if (this.initialized) {
            LoggingSystem.getLogger(this).warning("already initialized!");
            return;
        }
        this.initialized = true;
        this.toolManager.cleanUp();
        SceneGraphPath rootPath = new SceneGraphPath();
        rootPath.push(this.viewer.getSceneRoot());
        this.addTool(AnimatorTool.getInstanceImpl(this.KEY), rootPath);
        this.mouseOverSupport = new MouseOverSupport(rootPath);
        if (this.emptyPickPath.getLength() == 0) {
            this.emptyPickPath.push(this.viewer.getSceneRoot());
        }
        if (this.pickSystem != null) {
            this.pickSystem.setSceneRoot(this.viewer.getSceneRoot());
        }
        this.updater.setSceneRoot(this.viewer.getSceneRoot());
        this.eventQueue.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processToolEvent(ToolEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            this.executing = true;
        }
        this.compQueue.add(event);
        int iterCnt = 0;
        while (true) {
            ++iterCnt;
            this.processComputationalQueue();
            this.processTriggerQueue();
            List<ToolEvent> l = this.deviceManager.updateImplicitDevices();
            if (l.isEmpty()) break;
            this.compQueue.addAll(l);
            if (iterCnt <= 5000) continue;
            LoggingSystem.getLogger(this).warning("may be stuck in endless loop");
            iterCnt = 0;
        }
        Object object2 = this.mutex;
        synchronized (object2) {
            if (!this.toolsChanging.isEmpty()) {
                LinkedList<Pair> l = new LinkedList<Pair>(this.toolsChanging);
                this.toolsChanging.clear();
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    Pair p = (Pair)i.next();
                    i.remove();
                    if (p.added) {
                        this.addToolImpl(p.tool, p.path);
                        continue;
                    }
                    this.removeToolImpl(p.tool, p.path);
                }
            }
            this.executing = false;
        }
        if (event.getInputSlot() == InputSlot.getDevice("SystemTime")) {
            this.deviceManager.setSystemTime(event.getTimeStamp());
            if (this.renderTrigger != null) {
                this.renderTrigger.finishCollect();
                this.renderTrigger.startCollect();
            }
        }
    }

    protected void processComputationalQueue() {
        while (!this.compQueue.isEmpty()) {
            ToolEvent event = this.compQueue.removeFirst();
            this.deviceManager.evaluateEvent(event, this.compQueue);
            if (!this.isTrigger(event) || event.isConsumed()) continue;
            this.triggerQueue.add(event);
        }
    }

    private boolean isTrigger(ToolEvent event) {
        InputSlot slot = event.getInputSlot();
        boolean ret = this.slotManager.isActiveSlot(slot) || this.slotManager.isActivationSlot(slot);
        return ret;
    }

    protected void processTriggerQueue() {
        if (this.triggerQueue.isEmpty()) {
            return;
        }
        HashSet<Tool> activatedTools = new HashSet<Tool>();
        HashSet<Tool> deactivatedTools = new HashSet<Tool>();
        HashSet<Tool> stillActiveTools = new HashSet<Tool>();
        SceneGraphPath pickPath = null;
        Iterator i$ = this.triggerQueue.iterator();
        while (i$.hasNext()) {
            InputSlot slot;
            ToolEvent event;
            this.toolContext.event = event = (ToolEvent)i$.next();
            this.toolContext.sourceSlot = slot = event.getInputSlot();
            this.pickResults = null;
            this.pickResult = null;
            AxisState axis = this.deviceManager.getAxisState(slot);
            boolean noTrigger = true;
            if (axis != null && axis.isPressed()) {
                HashSet<Tool> candidatesForPick = new HashSet<Tool>(this.slotManager.getToolsActivatedBySlot(slot));
                HashSet<Tool> candidates = new HashSet<Tool>();
                for (Tool candidate : candidatesForPick) {
                    if (this.toolManager.needsPick(candidate)) continue;
                    LoggingSystem.getLogger(this).warning("Something wrong with pick candidates\n");
                }
                if (!candidatesForPick.isEmpty()) {
                    if (pickPath == null) {
                        pickPath = this.calculatePickPath();
                    }
                    int level = pickPath.getLength();
                    do {
                        Collection<Tool> selection;
                        if ((selection = this.toolManager.selectToolsForPath(pickPath, level--, candidatesForPick)).isEmpty()) continue;
                        LoggingSystem.getLogger(this).finer("selected pick tools:" + selection);
                        for (Tool tool : selection) {
                            this.registerActivePathForTool(pickPath, tool);
                        }
                        candidates.addAll(selection);
                        this.activateToolSet(candidates);
                    } while (candidates.isEmpty() && level > 0);
                    activatedTools.addAll(candidates);
                    noTrigger = candidates.isEmpty();
                }
            }
            if (axis != null && axis.isReleased()) {
                Set<Tool> deactivated = this.findDeactivatedTools(slot);
                deactivatedTools.addAll(deactivated);
                this.deactivateToolSet(deactivated);
                noTrigger = deactivated.isEmpty();
            }
            if (!noTrigger) continue;
            Set<Tool> active = this.slotManager.getActiveToolsForSlot(slot);
            stillActiveTools.addAll(active);
            this.processToolSet(active);
        }
        this.triggerQueue.clear();
        this.slotManager.updateMaps(stillActiveTools, activatedTools, deactivatedTools);
    }

    private void registerActivePathForTool(SceneGraphPath pickPath, Tool tool) {
        List<SceneGraphPath> ap = Collections.singletonList(pickPath.getLastElement() instanceof Geometry ? pickPath.popNew() : pickPath);
        this.toolToPath.put(tool, ap);
    }

    private void performPick() {
        if (this.pickSystem == null) {
            this.pickResults = Collections.emptyList();
            return;
        }
        pointerSlot = InputSlot.getDevice("PointerTransformation");
        this.currentPointer = this.deviceManager.getTransformationMatrix(pointerSlot).toDoubleArray(this.currentPointer);
        Rn.copy(this.pointerTrafo, this.currentPointer);
        double[] to = new double[]{-this.pointerTrafo[2], -this.pointerTrafo[6], -this.pointerTrafo[10], this.pointerTrafo[14]};
        double[] from = new double[]{this.pointerTrafo[3], this.pointerTrafo[7], this.pointerTrafo[11], this.pointerTrafo[15]};
        try {
            AABBPickSystem.getFrustumInterval(from, to, this.viewer);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.pickResults = this.pickSystem.computePick(from, to);
        if (!SystemProperties.isPortal) {
            if (this.hitFilter == null) {
                this.hitFilter = new PosWHitFilter(this.viewer);
            }
            this.hitFilter.update();
            AABBPickSystem.filterList(this.hitFilter, from, to, this.pickResults);
        }
    }

    private SceneGraphPath calculatePickPath() {
        this.performPick();
        if (this.pickResults.isEmpty()) {
            return this.emptyPickPath;
        }
        PickResult result = this.pickResults.get(0);
        LoggingSystem.getLogger(this).fine("ToolSystem.calculatePickPath() <HIT>");
        return result.getPickPath();
    }

    private void activateToolSet(Set<Tool> toolSet) {
        Iterator<Tool> iter = toolSet.iterator();
        while (iter.hasNext()) {
            Tool tool = iter.next();
            this.toolContext.setCurrentTool(tool);
            this.toolContext.event.device = this.slotManager.resolveSlotForTool(tool, this.toolContext.sourceSlot);
            if (this.toolContext.event.device == null) {
                LoggingSystem.getLogger(this).warning("activate: resolving " + this.toolContext.sourceSlot + " failed: " + tool.getClass().getName());
            }
            for (SceneGraphPath path : this.getActivePathsForTool(tool)) {
                this.toolContext.setRootToLocal(path);
                tool.activate(this.toolContext);
                if (!this.toolContext.isRejected()) continue;
                iter.remove();
                this.toolContext.rejected = false;
            }
        }
    }

    private void processToolSet(Set<Tool> toolSet) {
        for (Tool tool : toolSet) {
            this.toolContext.setCurrentTool(tool);
            this.toolContext.event.device = this.slotManager.resolveSlotForTool(tool, this.toolContext.sourceSlot);
            for (SceneGraphPath path : this.getActivePathsForTool(tool)) {
                this.toolContext.setRootToLocal(path);
                tool.perform(this.toolContext);
            }
        }
    }

    private List<SceneGraphPath> getActivePathsForTool(Tool tool) {
        List<SceneGraphPath> l = this.toolToPath.get(tool);
        if (l == null) {
            return Collections.emptyList();
        }
        return l;
    }

    private void deactivateToolSet(Set<Tool> toolSet) {
        for (Tool tool : toolSet) {
            this.toolContext.setCurrentTool(tool);
            this.toolContext.event.device = this.slotManager.resolveSlotForTool(tool, this.toolContext.sourceSlot);
            if (this.toolContext.event.device == null) {
                LoggingSystem.getLogger(this).warning("deavtivate: resolving " + this.toolContext.sourceSlot + " failed: " + tool.getClass().getName());
            }
            for (SceneGraphPath path : this.getActivePathsForTool(tool)) {
                this.toolContext.setRootToLocal(path);
                tool.deactivate(this.toolContext);
            }
        }
    }

    private Set<Tool> findDeactivatedTools(InputSlot slot) {
        return this.slotManager.getToolsDeactivatedBySlot(slot);
    }

    public void setPickSystem(PickSystem pickSystem) {
        this.pickSystem = pickSystem;
        if (pickSystem != null) {
            pickSystem.setSceneRoot(this.viewer.getSceneRoot());
        }
    }

    public PickSystem getPickSystem() {
        return this.pickSystem;
    }

    public void setAvatarPath(SceneGraphPath p) {
        this.avatarPath = p;
        this.deviceManager.setAvatarPath(this.avatarPath);
    }

    public SceneGraphPath getAvatarPath() {
        return this.avatarPath != null ? this.avatarPath : this.viewer.getCameraPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            this.disposed = true;
            while (this.executing) {
                try {
                    this.mutex.wait(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.deviceManager.dispose();
        this.eventQueue.dispose();
        this.updater.dispose();
        AnimatorTool.disposeInstance(this.KEY);
        ToolSystem.unsetToolSystem(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTool(Tool tool, SceneGraphPath path) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            if (this.executing) {
                this.toolsChanging.add(new Pair(tool, path, true));
            } else {
                this.addToolImpl(tool, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTool(Tool tool, SceneGraphPath path) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.disposed) {
                return;
            }
            if (this.executing) {
                this.toolsChanging.add(new Pair(tool, path, false));
            } else {
                this.removeToolImpl(tool, path);
            }
        }
    }

    void addToolImpl(Tool tool, SceneGraphPath path) {
        boolean first = this.toolManager.addTool(tool, path);
        if (!this.toolManager.needsPick(tool)) {
            List<SceneGraphPath> l = this.toolToPath.get(tool);
            if (l == null) {
                l = new LinkedList<SceneGraphPath>();
                this.toolToPath.put(tool, l);
            }
            try {
                l.add(path);
            }
            catch (UnsupportedOperationException e) {
                System.out.println("try adding to sigleton: " + tool);
            }
        }
        if (first) {
            this.slotManager.registerTool(tool);
            if (tool.getActivationSlots().contains(InputSlot.POINTER_HIT)) {
                this.mouseOverSupport.mouseOverToolAdded();
            }
        }
        LoggingSystem.getLogger(this).info("first=" + first + " tool=" + tool + "   path=" + path);
    }

    void removeToolImpl(Tool tool, SceneGraphPath path) {
        boolean last = this.toolManager.removeTool(tool, path);
        for (SceneGraphPath activePath : this.getActivePathsForTool(tool)) {
            if (!path.isEqual(activePath)) continue;
            ToolEvent te = new ToolEvent(this, -1L, InputSlot.getDevice("remove"), null, null);
            this.toolContext.setCurrentTool(tool);
            this.toolContext.setRootToLocal(path);
            this.toolContext.event = te;
            tool.deactivate(this.toolContext);
            this.toolToPath.remove(tool);
        }
        if (last) {
            this.slotManager.unregisterTool(tool);
            if (tool.getActivationSlots().contains(InputSlot.POINTER_HIT)) {
                this.mouseOverSupport.mouseOverToolRemoved();
            }
        }
        LoggingSystem.getLogger(this).info("last=" + last + " tool=" + tool + " path=" + path);
    }

    public SceneGraphPath getEmptyPickPath() {
        return this.emptyPickPath;
    }

    public void setEmptyPickPath(SceneGraphPath emptyPickPath) {
        if (emptyPickPath != null) {
            if (emptyPickPath.getFirstElement().getName() != this.viewer.getSceneRoot().getName()) {
                throw new IllegalArgumentException("empty pick path must start at scene root!");
            }
            if (emptyPickPath.getFirstElement() != this.viewer.getSceneRoot()) {
                LoggingSystem.getLogger(this).warning("Strange situation: same names but different scene roots");
            }
            this.emptyPickPath = emptyPickPath;
        } else {
            this.emptyPickPath = new SceneGraphPath();
            this.emptyPickPath.push(this.viewer.getSceneRoot());
        }
    }

    public RenderTrigger getRenderTrigger() {
        return this.renderTrigger;
    }

    public Object getKey() {
        return this.KEY;
    }

    public List getPickResults() {
        return this.pickResults;
    }

    public HashMap<Tool, List<SceneGraphPath>> getToolToPath() {
        return this.toolToPath;
    }

    public ToolUpdateProxy getToolUpdateProxy() {
        return this.updater;
    }

    protected static class Pair {
        final Tool tool;
        final SceneGraphPath path;
        final boolean added;

        Pair(Tool tool, SceneGraphPath path, boolean added) {
            this.path = path;
            this.tool = tool;
            this.added = added;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MouseOverSupport
    implements Tool {
        List<InputSlot> activation = Collections.emptyList();
        List<InputSlot> pointer = Collections.singletonList(InputSlot.getDevice("PointerTransformation"));
        InputSlot trigger = InputSlot.getDevice("PointerHit");
        SceneGraphPath rootPath;
        int useCount = 0;
        boolean hasHit = false;
        SceneGraphPath lastPath = null;
        int ignoreCnt = 12;

        void mouseOverToolAdded() {
            if (this.useCount == 0) {
                ToolSystem.this.addToolImpl(this, this.rootPath);
            }
            ++this.useCount;
        }

        void mouseOverToolRemoved() {
            --this.useCount;
            if (this.useCount == 0) {
                ToolSystem.this.removeToolImpl(this, this.rootPath);
            }
        }

        private MouseOverSupport(SceneGraphPath root) {
            this.rootPath = new SceneGraphPath(root);
        }

        @Override
        public void activate(ToolContext tc) {
        }

        @Override
        public void deactivate(ToolContext tc) {
        }

        @Override
        public List<InputSlot> getActivationSlots() {
            return this.activation;
        }

        @Override
        public List<InputSlot> getCurrentSlots() {
            return this.pointer;
        }

        @Override
        public String getDescription(InputSlot slot) {
            return "foo";
        }

        @Override
        public String getDescription() {
            return "dummy tool to enable mouse over";
        }

        @Override
        public void perform(ToolContext tc) {
            if (this.ignoreCnt > 0) {
                --this.ignoreCnt;
                return;
            }
            SceneGraphPath newP = null;
            boolean hits = false;
            PickResult p = tc.getCurrentPick();
            if (p != null && p.getPickPath() != null && p.getPickPath().getLastElement() instanceof Geometry) {
                newP = new SceneGraphPath(p.getPickPath());
                hits = true;
            }
            if (!hits) {
                if (this.hasHit) {
                    this.hasHit = false;
                    this.lastPath = null;
                    this.fireNoMoreHit();
                }
            } else if (this.hasHit) {
                if (!this.lastPath.isEqual(newP)) {
                    this.lastPath = newP;
                    this.fireNoMoreHit();
                    this.fireHit();
                }
            } else {
                this.lastPath = newP;
                this.hasHit = true;
                this.fireHit();
            }
        }

        private void fireNoMoreHit() {
            ToolSystem.this.eventQueue.addEvent(new ToolEvent((Object)this, ToolSystem.this.deviceManager.getSystemTime(), this.trigger, AxisState.ORIGIN));
        }

        private void fireHit() {
            ToolSystem.this.eventQueue.addEvent(new ToolEvent((Object)this, ToolSystem.this.deviceManager.getSystemTime(), this.trigger, AxisState.PRESSED));
        }

        public int hashCode() {
            return 31;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            throw new IllegalStateException("Duplicate MouseOverSupport!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToolContextImpl
    implements ToolContext {
        InputSlot sourceSlot;
        ToolEvent event;
        private SceneGraphPath rootToLocal;
        private SceneGraphPath rootToToolComponent;
        private Tool currentTool;
        boolean rejected;

        private ToolContextImpl() {
        }

        @Override
        public Viewer getViewer() {
            return ToolSystem.this.viewer;
        }

        @Override
        public InputSlot getSource() {
            return this.event.getInputSlot();
        }

        @Override
        public DoubleArray getTransformationMatrix(InputSlot slot) {
            return ToolSystem.this.deviceManager.getTransformationMatrix(slot);
        }

        @Override
        public AxisState getAxisState(InputSlot slot) {
            return ToolSystem.this.deviceManager.getAxisState(slot);
        }

        @Override
        public long getTime() {
            return this.event.getTimeStamp();
        }

        private void setRootToLocal(SceneGraphPath rootToLocal) {
            this.rootToLocal = rootToLocal;
            this.rootToToolComponent = null;
        }

        @Override
        public SceneGraphPath getRootToLocal() {
            return this.rootToLocal;
        }

        @Override
        public SceneGraphPath getRootToToolComponent() {
            if (this.rootToToolComponent == null) {
                LinkedList<SceneGraphNode> list = new LinkedList<SceneGraphNode>();
                Iterator<SceneGraphNode> i = this.rootToLocal.reverseIterator();
                while (i.hasNext()) {
                    SceneGraphNode cp = i.next();
                    if (!(cp instanceof SceneGraphComponent) || !((SceneGraphComponent)cp).getTools().contains(this.currentTool)) continue;
                    list.addFirst(cp);
                    while (i.hasNext()) {
                        list.addFirst(i.next());
                    }
                }
                this.rootToToolComponent = SceneGraphPath.fromList(list);
            }
            return this.rootToToolComponent;
        }

        @Override
        public PickResult getCurrentPick() {
            if (ToolSystem.this.pickResult == null) {
                ToolSystem.this.performPick();
                ToolSystem.this.pickResult = ToolSystem.this.pickResults.isEmpty() ? null : (PickResult)ToolSystem.this.pickResults.get(0);
            }
            return ToolSystem.this.pickResult;
        }

        @Override
        public List<PickResult> getCurrentPicks() {
            if (ToolSystem.this.pickResults == null) {
                ToolSystem.this.performPick();
            }
            return ToolSystem.this.pickResults;
        }

        private void setCurrentTool(Tool currentTool) {
            this.currentTool = currentTool;
        }

        @Override
        public void reject() {
            this.rejected = true;
        }

        boolean isRejected() {
            return this.rejected;
        }

        @Override
        public SceneGraphPath getAvatarPath() {
            return ToolSystem.this.getAvatarPath();
        }

        @Override
        public PickSystem getPickSystem() {
            return ToolSystem.this.getPickSystem();
        }

        @Override
        public Object getKey() {
            return ToolSystem.this.KEY;
        }
    }
}

