/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.tool.Tool;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolManager {
    private final HashSet<Tool> toolsWithPick = new HashSet();
    private final HashMap<Tool, List<SceneGraphPath>> toolToPaths = new HashMap();

    boolean addTool(Tool tool, SceneGraphPath path) {
        boolean first = this.pathsForTool(tool).isEmpty();
        if (this.pathsForTool(tool).contains(path)) {
            throw new IllegalStateException("Tool " + tool + " already registered with path=" + path);
        }
        this.pathsForTool(tool).add(path);
        if (!tool.getActivationSlots().isEmpty() && !this.toolsWithPick.contains(tool)) {
            this.toolsWithPick.add(tool);
        }
        return first;
    }

    boolean removeTool(Tool tool, SceneGraphPath path) {
        if (!this.pathsForTool(tool).contains(path)) {
            throw new IllegalStateException();
        }
        this.pathsForTool(tool).remove(path);
        if (this.pathsForTool(tool).isEmpty()) {
            if (!tool.getActivationSlots().isEmpty()) {
                this.toolsWithPick.remove(tool);
            }
            return true;
        }
        return false;
    }

    void cleanUp() {
        this.toolToPaths.clear();
        this.toolsWithPick.clear();
    }

    Set getTools() {
        return Collections.unmodifiableSet(this.toolToPaths.keySet());
    }

    boolean needsPick(Tool candidate) {
        return this.toolsWithPick.contains(candidate);
    }

    private List<SceneGraphPath> pathsForTool(Tool t) {
        if (!this.toolToPaths.containsKey(t)) {
            this.toolToPaths.put(t, new LinkedList());
        }
        return this.toolToPaths.get(t);
    }

    SceneGraphPath getPathForTool(Tool tool, SceneGraphPath pickPath) {
        if (pickPath == null) {
            if (this.pathsForTool(tool).size() != 1) {
                throw new IllegalStateException("ambigous path without pick");
            }
            return this.pathsForTool(tool).get(0);
        }
        for (SceneGraphPath path : this.pathsForTool(tool)) {
            if (!pickPath.startsWith(path)) continue;
            return path;
        }
        return null;
    }

    Collection<Tool> selectToolsForPath(SceneGraphPath pickPath, int depth, Set<Tool> candidates) {
        Iterator<SceneGraphNode> iter = pickPath.reverseIterator(depth);
        while (iter.hasNext()) {
            SceneGraphNode node = iter.next();
            if (!(node instanceof SceneGraphComponent)) continue;
            List<Tool> tools = ((SceneGraphComponent)node).getTools();
            LinkedList<Tool> copy = new LinkedList<Tool>();
            copy.addAll(tools);
            copy.retainAll(candidates);
            if (copy.isEmpty()) continue;
            return copy;
        }
        return Collections.emptySet();
    }
}

