/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.scene.tool.InputSlot;
import de.jreality.toolsystem.ToolEvent;
import de.jreality.toolsystem.ToolEventReceiver;
import de.jreality.util.LoggingSystem;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;

public class ToolEventQueue {
    private ToolEventReceiver receiver;
    private LinkedList<ToolEvent> queue = new LinkedList();
    private final Object mutex = new Object();
    protected volatile boolean running = true;
    private Runnable eventThread = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ToolEvent event = null;
            while (ToolEventQueue.this.running) {
                Object object = ToolEventQueue.this.mutex;
                synchronized (object) {
                    while (ToolEventQueue.this.queue.isEmpty() && ToolEventQueue.this.running) {
                        try {
                            ToolEventQueue.this.mutex.wait();
                        }
                        catch (InterruptedException e) {
                            throw new Error();
                        }
                    }
                    LinkedList linkedList = ToolEventQueue.this.queue;
                    synchronized (linkedList) {
                        event = ToolEventQueue.this.running && !ToolEventQueue.this.queue.isEmpty() ? (ToolEvent)ToolEventQueue.this.queue.removeFirst() : null;
                    }
                }
                if (!ToolEventQueue.this.running || event == null) continue;
                try {
                    ToolEventQueue.this.receiver.processToolEvent(event);
                }
                catch (Exception exception) {}
            }
        }
    };
    private volatile boolean started = false;
    private Thread thread = new Thread(this.eventThread);

    public ToolEventQueue(ToolEventReceiver receiver) {
        this.thread.setName("jReality ToolSystem EventQueue");
        this.receiver = receiver;
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        this.thread.start();
    }

    public boolean addEvent(ToolEvent event) {
        if (!this.started) {
            return false;
        }
        this.placeEvent(event);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean placeEvent(ToolEvent event) {
        Object object = this.mutex;
        synchronized (object) {
            if (!this.running) {
                return false;
            }
            ListIterator<ToolEvent> i = this.queue.listIterator(this.queue.size());
            while (i.hasPrevious()) {
                ToolEvent e = i.previous();
                if (!event.canReplace(e)) continue;
                LoggingSystem.getLogger(this).log(e.getInputSlot() == InputSlot.getDevice("SystemTime") ? Level.FINEST : Level.FINER, "replacing ToolEvent {0} with {1}", new Object[]{e, event});
                e.replaceWith(event);
                return false;
            }
            this.queue.addLast(event);
            this.mutex.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            this.running = false;
            this.mutex.notifyAll();
            LinkedList<ToolEvent> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.clear();
            }
        }
    }

    public Thread getThread() {
        return this.thread;
    }
}

