/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.scene.data.DoubleArray;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ToolEvent
implements Serializable {
    private static final long serialVersionUID = -574219336588808514L;
    InputSlot device;
    protected AxisState axis;
    protected DoubleArray trafo;
    protected long time;
    private boolean consumed;
    private transient Object source;

    public ToolEvent(Object source, InputSlot device, AxisState axis) {
        this(source, System.currentTimeMillis(), device, axis);
    }

    public ToolEvent(Object source, long when, InputSlot device, AxisState axis) {
        this(source, when, device, axis, null);
    }

    public ToolEvent(Object source, InputSlot device, DoubleArray trafo) {
        this(source, System.currentTimeMillis(), device, trafo);
    }

    public ToolEvent(Object source, long when, InputSlot device, DoubleArray trafo) {
        this(source, when, device, null, trafo);
    }

    public ToolEvent(Object source, long when, InputSlot device, AxisState axis, DoubleArray trafo) {
        this.source = source;
        this.time = when;
        this.device = device;
        this.axis = axis;
        this.trafo = trafo;
    }

    public InputSlot getInputSlot() {
        return this.device;
    }

    public AxisState getAxisState() {
        return this.axis;
    }

    public DoubleArray getTransformation() {
        return this.trafo;
    }

    public long getTimeStamp() {
        return this.time;
    }

    public String toString() {
        return "ToolEvent source=" + this.getSource() + " device=" + this.device + " " + this.axis + " trafo=" + this.trafo;
    }

    public Object getSource() {
        return this.source;
    }

    protected void replaceWith(ToolEvent replacement) {
        this.axis = replacement.axis;
        this.trafo = replacement.trafo;
    }

    protected boolean canReplace(ToolEvent e) {
        return this.device == e.device && this.getSource() == e.getSource() && this.compareTransformation(this.trafo, e.trafo) && this.compareAxisStates(this.axis, e.axis);
    }

    protected boolean compareAxisStates(AxisState axis1, AxisState axis2) {
        if (axis1 == axis2) {
            return true;
        }
        if (axis1 == null || axis2 == null) {
            return axis1 == axis2;
        }
        if (axis1.doubleValue() * axis2.doubleValue() <= 0.0) {
            return false;
        }
        if (axis1.isPressed() && !axis2.isPressed() || !axis1.isPressed() && axis2.isPressed() || axis1.isReleased() && !axis2.isReleased() || !axis1.isReleased() && axis2.isReleased()) {
            return false;
        }
        return axis1.doubleValue() - axis2.doubleValue() < 1.0E-4;
    }

    protected boolean compareTransformation(DoubleArray trafo1, DoubleArray trafo2) {
        if (trafo1 == trafo2) {
            return true;
        }
        if (trafo1 == null || trafo1 == null) {
            return trafo1 == trafo2;
        }
        return false;
    }

    public void consume() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.device.getName());
        out.writeObject(this.axis);
        if (this.trafo != null) {
            out.writeObject(this.trafo.toDoubleArray(null));
        } else {
            out.writeObject(null);
        }
        out.writeLong(this.time);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.device = InputSlot.getDevice(in.readUTF());
        this.axis = (AxisState)in.readObject();
        double[] m = (double[])in.readObject();
        if (m != null) {
            this.trafo = new DoubleArray(m);
        }
        this.time = in.readLong();
        this.source = "REMOTE";
    }
}

