/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.toolsystem;

import de.jreality.toolsystem.raw.PollingDevice;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.Timer;

class Poller
implements ActionListener {
    private final Timer timer;
    private final LinkedList<PollingDevice> pollingDevices = new LinkedList();
    private static final long period = 5L;
    private static Poller pollerInstance = new Poller();

    static Poller getSharedInstance() {
        return pollerInstance;
    }

    private Poller() {
        this.timer = new Timer(5, this);
        this.timer.setCoalesce(true);
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollDevices() {
        LinkedList<PollingDevice> linkedList = this.pollingDevices;
        synchronized (linkedList) {
            for (PollingDevice pd : this.pollingDevices) {
                pd.poll();
            }
        }
    }

    void addPollingDevice(final PollingDevice pd) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Poller.this.pollingDevices.add(pd);
            }
        });
    }

    void removePollingDevice(final PollingDevice pd) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Poller.this.pollingDevices.remove(pd);
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        this.pollDevices();
    }
}

