/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.Primitives;
import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Sphere;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.util.SceneGraphUtility;
import java.awt.Color;

public class TrackballRotateTool
extends AbstractTool {
    static InputSlot activationSlot = InputSlot.getDevice("RotateActivation");
    static InputSlot evolutionSlot = InputSlot.getDevice("TrackballTransformation");
    static InputSlot camPath = InputSlot.getDevice("WorldToCamera");
    transient SceneGraphComponent comp;
    int type = 0;
    transient EffectiveAppearance eap;
    boolean allesInOrdnung = true;
    boolean positiveOrientation = true;
    private transient int metric;
    transient Matrix result = new Matrix();
    transient Matrix evolution = new Matrix();
    static double[][] fixedAxes = new double[][]{{0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}};
    double radius = 1.0;
    SceneGraphComponent allSGC;
    SceneGraphComponent ballSGC;
    SceneGraphComponent xyBand;
    SceneGraphComponent yzBand;
    SceneGraphComponent zxBand;

    public TrackballRotateTool() {
        super(activationSlot);
        this.addCurrentSlot(evolutionSlot);
        this.addCurrentSlot(camPath);
    }

    public void activate(ToolContext tc) {
        String name;
        System.err.println("Activating trackball rotate tool");
        this.comp = tc.getRootToToolComponent().getLastComponent();
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        this.allesInOrdnung = true;
        SceneGraphComponent leaf = tc.getRootToLocal().getLastComponent();
        if (leaf.getName() == "band") {
            SceneGraphPath shorter = tc.getRootToLocal().popNew();
            leaf = shorter.getLastComponent();
        }
        if ((name = leaf.getName()).equals("ball")) {
            this.type = 0;
        } else if (name.equals("xyBand")) {
            this.type = 1;
        } else if (name.equals("yzBand")) {
            this.type = 2;
        } else if (name.equals("zxBand")) {
            this.type = 3;
        } else {
            this.allesInOrdnung = false;
        }
        System.err.println("Type is " + this.type);
        this.metric = this.eap.getAttribute("metric", 0);
    }

    public void perform(ToolContext tc) {
        if (!this.allesInOrdnung) {
            return;
        }
        Matrix root2Tool = new Matrix(tc.getRootToToolComponent().getInverseMatrix(null));
        root2Tool.assignFrom(P3.extractOrientationMatrix(null, root2Tool.getArray(), P3.originP3, this.metric));
        this.evolution.assignFrom(tc.getTransformationMatrix(evolutionSlot));
        this.evolution.conjugateBy(root2Tool);
        if (this.type > 0) {
            FactoredMatrix fm = new FactoredMatrix(this.evolution.getArray());
            fm.update();
            double angle = fm.getRotationAngle();
            double[] axis = fm.getRotationAxis();
            double[] newAxis = new double[3];
            double[] fa = fixedAxes[this.type - 1];
            Rn.projectOnto(newAxis, axis, fa);
            MatrixBuilder.euclidean().rotate(angle, newAxis).assignTo(this.evolution);
        }
        this.comp.getTransformation().multiplyOnRight(this.evolution.getArray());
        tc.getViewer().renderAsync();
    }

    public SceneGraphComponent getTrackball() {
        this.allSGC = SceneGraphUtility.createFullSceneGraphComponent("trackball repn");
        MatrixBuilder.euclidean().scale(this.radius).assignTo(this.allSGC);
        this.allSGC.getAppearance().setAttribute("showLines", false);
        this.allSGC.getAppearance().setAttribute("showPoints", false);
        this.ballSGC = SceneGraphUtility.createFullSceneGraphComponent("ball");
        this.ballSGC.setGeometry(new Sphere());
        this.ballSGC.getAppearance().setAttribute("transparencyEnabled", true);
        this.ballSGC.getAppearance().setAttribute("transparency", 0.95);
        MatrixBuilder.euclidean().scale(0.8).assignTo(this.ballSGC);
        SceneGraphComponent band = new SceneGraphComponent("band");
        MatrixBuilder.euclidean().scale(1.0, 1.0, 0.1).assignTo(band);
        band.setGeometry(Primitives.cylinder(50));
        this.xyBand = SceneGraphUtility.createFullSceneGraphComponent("xyBand");
        this.xyBand.getAppearance().setAttribute("polygonShader.diffuseColor", Color.blue);
        this.xyBand.addChild(band);
        this.yzBand = SceneGraphUtility.createFullSceneGraphComponent("yzBand");
        this.yzBand.getAppearance().setAttribute("polygonShader.diffuseColor", Color.red);
        MatrixBuilder.euclidean().rotateY(1.5707963267948966).assignTo(this.yzBand);
        this.yzBand.addChild(band);
        this.zxBand = SceneGraphUtility.createFullSceneGraphComponent("zxBand");
        this.zxBand.getAppearance().setAttribute("polygonShader.diffuseColor", Color.green);
        MatrixBuilder.euclidean().rotateX(1.5707963267948966).assignTo(this.zxBand);
        this.zxBand.addChild(band);
        this.allSGC.addChildren(this.ballSGC, this.xyBand, this.yzBand, this.zxBand);
        return this.allSGC;
    }
}

