/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.AnimatorTool;
import de.jreality.tools.TimerQueue;
import de.jreality.toolsystem.ToolSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer
extends javax.swing.Timer {
    long expireTime;
    Timer next;
    boolean running;
    TimerQueue timerQueue;

    public Timer(int delay, ActionListener listener) {
        super(delay, listener);
    }

    public void attach(ToolSystem ts) {
        this.attach(AnimatorTool.getInstance(ts));
    }

    public void attach(ToolContext tc) {
        this.attach(AnimatorTool.getInstance(tc));
    }

    public void attach(AnimatorTool at) {
        if (this.timerQueue != null) {
            return;
        }
        this.timerQueue = at.getTimerQueue();
    }

    public void attach(SceneGraphComponent cmp) {
        if (this.timerQueue != null) {
            return;
        }
        cmp.addTool(new AbstractTool(new InputSlot[0]){
            {
                this.addCurrentSlot(InputSlot.getDevice("SystemTime"));
            }

            public void perform(ToolContext tc) {
                Timer.this.attach(tc);
                tc.getRootToToolComponent().getLastComponent().removeTool(this);
            }
        });
    }

    TimerQueue timerQueue() {
        return this.timerQueue;
    }

    public void start() {
        if (this.timerQueue == null) {
            throw new IllegalStateException("timer not attached!");
        }
        this.timerQueue().addTimer(this);
    }

    public boolean isRunning() {
        return this.timerQueue != null && this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
    }

    synchronized void perform(long currentTime) {
        this.fireActionPerformed(new ActionEvent(this, 0, null, currentTime, 0));
    }
}

