/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Pn;

public class ShowPropertiesToolLogger {
    private String log;
    private boolean homogeneous = true;

    public ShowPropertiesToolLogger() {
    }

    public ShowPropertiesToolLogger(String str) {
        this();
        this.setLine(str);
    }

    public void addLine(String newLine) {
        this.log = this.log == null ? new String(newLine) : this.log + "\n" + newLine;
    }

    public void addLine(String description, double[] point) {
        this.addLine(description + ": ");
        this.addPoint(point);
    }

    public void addLine(String description, int[] ints) {
        this.addLine(description + ": ");
        this.addPoint(ints);
    }

    public void addLine(double[] point) {
        this.addLine("point", point);
    }

    public void addPoint(double[] point) {
        if (point == null) {
            this.log = this.log + "null";
            return;
        }
        if (point.length < 1) {
            return;
        }
        String newStr = "";
        int length = point.length;
        double[] writePoint = point;
        if (length == 4 && !this.homogeneous) {
            writePoint = new double[--length];
            Pn.dehomogenize(writePoint, point);
            if (point[3] == 0.0) {
                newStr = newStr + " (inf) ";
            }
        }
        newStr = newStr + point[0];
        for (int i = 1; i < length; ++i) {
            newStr = newStr + ", " + writePoint[i];
        }
        this.log = this.log + newStr;
    }

    public void addPoint(int[] ints) {
        if (ints == null) {
            this.log = this.log + "null";
            return;
        }
        String newStr = "" + ints[0];
        for (int i = 1; i < ints.length; ++i) {
            newStr = newStr + ", " + ints[i];
        }
        this.log = this.log + newStr;
    }

    public void clear() {
        this.log = null;
    }

    public void setLine(String line) {
        this.clear();
        this.addLine(line);
    }

    public String getLog() {
        if (this.log == null) {
            this.log = "";
        }
        return this.log;
    }

    public void setHomogeneousLogging(boolean hom) {
        this.homogeneous = hom;
    }
}

