/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.Rn;
import de.jreality.scene.Geometry;
import de.jreality.scene.IndexedFaceSet;
import de.jreality.scene.IndexedLineSet;
import de.jreality.scene.PointSet;
import de.jreality.scene.data.Attribute;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.ShowPropertiesToolLogger;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ShowPropertiesTool
extends AbstractTool {
    private static final InputSlot pointerSlot = InputSlot.getDevice("PointerTransformation");
    private Geometry geo;
    private Matrix obj2WorldTrans;
    private int pickIndex;
    private Matrix pointerTrans = new Matrix();
    private boolean geometryMatched;
    private ShowPropertiesToolLogger[] log = new ShowPropertiesToolLogger[3];
    private boolean holdLog = false;
    private boolean holdLogFrame = true;
    private double[] from;
    private double[] dir;
    private double[] pickedPointOC;
    private double[] pickedPointWC;
    private double[] pickedPointNormalOC;
    private double[] pickedPointNormalWC;
    private double[] pickedPointTexC;
    private int[] pickedEdgeVertexInds;
    private double[][] pickedEdgeVerts;
    private int[] pickedFaceVertexInds;
    private double[][] pickedFaceVerts;
    private double[] pickedObjectWC;
    private Frame logFrame;
    private TextArea ta;

    public ShowPropertiesTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(pointerSlot);
        for (int i = 0; i < this.log.length; ++i) {
            this.log[i] = new ShowPropertiesToolLogger();
        }
        this.initLogFrame();
    }

    public void activate(ToolContext tc) {
        this.showLogFrame(true);
        this.perform(tc);
    }

    public void perform(ToolContext tc) {
        for (int i = 0; i < this.log.length; ++i) {
            this.log[i].clear();
        }
        tc.getTransformationMatrix(pointerSlot).toDoubleArray(this.pointerTrans.getArray());
        this.evalPointer();
        PickResult currentPick = tc.getCurrentPick();
        boolean bl = this.geometryMatched = currentPick != null;
        if (this.geometryMatched) {
            this.geo = currentPick.getPickPath().getLastComponent().getGeometry();
            this.pickIndex = currentPick.getIndex();
            this.obj2WorldTrans = new Matrix(currentPick.getPickPath().getMatrix(null));
            if (currentPick.getPickType() == 4) {
                this.evalPoint(tc);
            }
            if (currentPick.getPickType() == 2) {
                this.evalEdge(tc);
            }
            if (currentPick.getPickType() == 1) {
                this.evalFace(tc);
            }
            if (currentPick.getPickType() == 0) {
                this.evalObject(tc);
            }
        }
        this.print();
    }

    public void deactivate(ToolContext tc) {
        if (!this.holdLog) {
            this.showLogFrame(false);
            for (int i = 0; i < this.log.length; ++i) {
                this.log[i].clear();
            }
            this.print();
        }
    }

    private void evalPointer() {
        this.from = this.pointerTrans.getColumn(3);
        this.dir = Rn.times(null, -1.0, this.pointerTrans.getColumn(2));
        this.log[0].addLine("pointerOnNearClippingPlane", this.from);
        this.log[0].addLine("pointerDirection", this.dir);
    }

    private void evalPoint(ToolContext tc) {
        PickResult currentPick = tc.getCurrentPick();
        if (currentPick.getPickType() == 4) {
            this.pickedPointOC = ((PointSet)this.geo).getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(this.pickIndex).toDoubleArray(null);
            this.pickedPointWC = this.obj2WorldTrans.multiplyVector(this.pickedPointOC);
            this.log[2].addLine("pickedPointObjCoords", this.pickedPointOC);
            this.log[2].addLine("pickedPointWorldCoords", this.pickedPointWC);
            if (((PointSet)this.geo).getVertexAttributes(Attribute.TEXTURE_COORDINATES) != null) {
                this.pickedPointTexC = ((PointSet)this.geo).getVertexAttributes(Attribute.TEXTURE_COORDINATES).toDoubleArrayArray().getValueAt(this.pickIndex).toDoubleArray(null);
                this.log[2].addLine("pickedPointTexC", this.pickedPointTexC);
            }
            if (((PointSet)this.geo).getVertexAttributes(Attribute.NORMALS) != null) {
                this.pickedPointNormalOC = ((IndexedFaceSet)this.geo).getVertexAttributes(Attribute.NORMALS).toDoubleArrayArray().getValueAt(this.pickIndex).toDoubleArray(null);
                this.pickedPointNormalWC = this.obj2WorldTrans.multiplyVector(this.pickedPointNormalOC);
                this.log[2].addLine("pickedPointNormalOC", this.pickedPointNormalOC);
                this.log[2].addLine("pickedPointNormalWC", this.pickedPointNormalWC);
            }
        } else {
            this.pickedPointOC = currentPick.getObjectCoordinates();
            this.pickedPointWC = this.obj2WorldTrans.multiplyVector(this.pickedPointOC);
            this.log[2].addLine("pickedPointObjCoords", this.pickedPointOC);
            this.log[2].addLine("pickedPointWorldCoords", this.pickedPointWC);
        }
        this.log[1].setLine("pickType: point");
    }

    private void evalEdge(ToolContext tc) {
        this.evalPoint(tc);
        PickResult currentPick = tc.getCurrentPick();
        if (currentPick.getPickType() != 2) {
            return;
        }
        if (((IndexedLineSet)this.geo).getEdgeAttributes(Attribute.INDICES) != null) {
            int i;
            this.pickedEdgeVertexInds = ((IndexedLineSet)this.geo).getEdgeAttributes(Attribute.INDICES).toIntArrayArray().getValueAt(this.pickIndex).toIntArray(null);
            this.pickedEdgeVerts = new double[this.pickedEdgeVertexInds.length][];
            for (i = 0; i < this.pickedEdgeVertexInds.length; ++i) {
                this.pickedEdgeVerts[i] = ((PointSet)this.geo).getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(this.pickedEdgeVertexInds[i]).toDoubleArray(null);
            }
            this.log[2].addLine("pickedEdgeVertexIndices", this.pickedEdgeVertexInds);
            this.log[2].addLine("edge contains points:");
            for (i = 0; i < this.pickedEdgeVertexInds.length; ++i) {
                this.log[2].addLine("\t", this.pickedEdgeVerts[i]);
            }
            this.log[1].setLine("pickType: line");
        }
    }

    private void evalFace(ToolContext tc) {
        this.evalPoint(tc);
        PickResult currentPick = tc.getCurrentPick();
        if (currentPick.getTextureCoordinates() != null) {
            this.pickedPointTexC = currentPick.getTextureCoordinates();
            this.log[2].addLine("pickedPointTexC", this.pickedPointTexC);
        }
        if (((IndexedFaceSet)this.geo).getFaceAttributes(Attribute.INDICES) != null) {
            int i;
            this.pickedFaceVertexInds = ((IndexedFaceSet)this.geo).getFaceAttributes(Attribute.INDICES).toIntArrayArray().getValueAt(this.pickIndex).toIntArray(null);
            this.pickedFaceVerts = new double[this.pickedFaceVertexInds.length][];
            for (i = 0; i < this.pickedFaceVertexInds.length; ++i) {
                this.pickedFaceVerts[i] = ((PointSet)this.geo).getVertexAttributes(Attribute.COORDINATES).toDoubleArrayArray().getValueAt(this.pickedFaceVertexInds[i]).toDoubleArray(null);
            }
            this.log[2].addLine("pickedFaceVertexIndices", this.pickedFaceVertexInds);
            this.log[2].addLine("face contains points:");
            for (i = 0; i < this.pickedFaceVertexInds.length; ++i) {
                this.log[2].addLine("\t", this.pickedFaceVerts[i]);
            }
            this.log[1].setLine("pickType: face");
        }
    }

    private void evalObject(ToolContext tc) {
        this.pickedObjectWC = this.obj2WorldTrans.getColumn(3);
        this.log[2].addLine("pickedObjectWorldCoords", this.pickedObjectWC);
        this.log[1].setLine("pick-type: object");
    }

    public double[] getFrom() {
        return this.from;
    }

    public double[] getDir() {
        return this.dir;
    }

    public boolean geometryMatched() {
        return this.geometryMatched;
    }

    public Matrix getObj2WorldTrans() {
        return this.obj2WorldTrans;
    }

    public double[] getPickedVertOC() {
        return this.pickedPointOC;
    }

    public double[] getPickedVertWC() {
        return this.pickedPointWC;
    }

    public double[] getPickedVertNormalOC() {
        return this.pickedPointNormalOC;
    }

    public double[] getPickedVertNormalWC() {
        return this.pickedPointNormalWC;
    }

    public double[] getPickedVertTexC() {
        return this.pickedPointTexC;
    }

    public int[] getPickedEdgeVertexInds() {
        return this.pickedEdgeVertexInds;
    }

    public double[][] getPickedEdgeVerts() {
        return this.pickedEdgeVerts;
    }

    public int[] getPickedFaceVertexInds() {
        return this.pickedFaceVertexInds;
    }

    public double[][] getPickedFaceVerts() {
        return this.pickedFaceVerts;
    }

    public double[] getPickedObjectWC() {
        return this.pickedObjectWC;
    }

    private void initLogFrame() {
        this.logFrame = new Frame();
        this.logFrame.setSize(800, 270);
        this.logFrame.setLocation(100, 700);
        if (this.holdLogFrame) {
            this.showLogFrame(true);
        }
        this.logFrame.setBackground(Color.white);
        this.logFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                ShowPropertiesTool.this.logFrame.dispose();
            }
        });
        this.ta = new TextArea();
        this.ta.setEditable(false);
        this.ta.setBackground(Color.white);
        this.logFrame.add(this.ta);
    }

    private void showLogFrame(boolean show) {
        if (this.holdLogFrame) {
            show = true;
        }
        this.logFrame.setVisible(show);
    }

    private void print() {
        this.ta.setText("");
        for (int i = 0; i < this.log.length; ++i) {
            this.ta.append(this.log[i].getLog());
            this.ta.append("\n");
            this.ta.append("\n");
        }
    }

    public void holdLog(boolean hold) {
        this.holdLog = hold;
    }

    public void holdLogFrame(boolean hold) {
        this.holdLogFrame = hold;
    }

    public void setHomogeneousLogging(boolean hom) {
        for (int i = 0; i < this.log.length; ++i) {
            this.log[i].setHomogeneousLogging(hom);
        }
    }
}

