/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

public class ShipRotateTool
extends AbstractTool {
    InputSlot leftRightSlot = InputSlot.getDevice("LeftRightAxis");
    InputSlot timerSlot = InputSlot.getDevice("SystemTime");
    double angle;
    boolean isRotating;
    double gain = 1.0;
    double[] tmp = new double[16];

    public ShipRotateTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.leftRightSlot);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == this.leftRightSlot) {
            this.angle = tc.getAxisState(this.leftRightSlot).doubleValue();
            this.angle = this.angle * this.angle * this.angle;
            if (tc.getAxisState(this.leftRightSlot).isReleased()) {
                this.isRotating = false;
                this.removeCurrentSlot(this.timerSlot);
                return;
            }
            if (!this.isRotating) {
                this.isRotating = true;
                this.addCurrentSlot(this.timerSlot);
            }
            return;
        }
        SceneGraphComponent ship = tc.getRootToToolComponent().getLastComponent();
        Matrix shipMatrix = new Matrix();
        if (ship.getTransformation() != null) {
            shipMatrix.assignFrom(ship.getTransformation());
        }
        double val = (double)tc.getAxisState(this.timerSlot).intValue() * 0.001;
        MatrixBuilder.euclidean(shipMatrix).rotateY(val * this.angle * this.gain).assignTo(ship);
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }
}

