/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.AxisState;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.util.LoggingSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ShipNavigationTool
extends AbstractTool {
    private final transient InputSlot forwardBackward = InputSlot.getDevice("ForwardBackwardAxis");
    private final transient InputSlot leftRight = InputSlot.getDevice("LeftRightAxis");
    private final transient InputSlot jump = InputSlot.getDevice("JumpActivation");
    private final transient InputSlot rotateActivation = InputSlot.getDevice("ShipRotateActivation");
    private final transient InputSlot horizontalRotation = InputSlot.getDevice("HorizontalShipRotationAngleEvolution");
    private final transient InputSlot timer = InputSlot.getDevice("SystemTime");
    private final transient InputSlot run = InputSlot.getDevice("RunActivation");
    private final transient InputSlot gravityToggle = InputSlot.getDevice("GravityToggle");
    private final transient InputSlot groundToggle = InputSlot.getDevice("GroundToggle");
    private transient double[] velocity = new double[]{0.0, 0.0, 0.0};
    private transient boolean touchGround;
    private double gain = 4.0;
    private double runFactor = 2.0;
    private double gravity = 9.81;
    private boolean gravitEnabled = true;
    private double jumpSpeed = 8.0;
    private boolean hasCenter = false;
    private double[] center = new double[]{0.0, 0.0, 0.0, 1.0};
    private transient boolean rotate = false;
    private transient boolean fall;
    private double minHeight;
    private PickDelegate pickDelegate;
    private transient boolean timerOnline;

    public ShipNavigationTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.forwardBackward);
        this.addCurrentSlot(this.leftRight);
        this.addCurrentSlot(this.rotateActivation);
        this.addCurrentSlot(this.jump);
        this.addCurrentSlot(this.gravityToggle);
        this.addCurrentSlot(this.groundToggle);
        this.addCurrentSlot(this.horizontalRotation);
    }

    public void perform(ToolContext tc) {
        if (tc.getSource() == this.gravityToggle) {
            if (tc.getAxisState(this.gravityToggle).isReleased()) {
                return;
            }
            this.setGravitEnabled(!this.isGravitEnabled());
        }
        if (tc.getSource() == this.groundToggle) {
            this.fall = tc.getAxisState(this.groundToggle).isPressed();
            if (this.fall) {
                this.touchGround = false;
            }
        }
        if (this.rotate) {
            if (!tc.getAxisState(this.rotateActivation).isPressed()) {
                this.removeCurrentSlot(this.horizontalRotation);
                this.rotate = false;
            }
        } else if (tc.getAxisState(this.rotateActivation).isPressed()) {
            this.addCurrentSlot(this.horizontalRotation);
            this.rotate = true;
        }
        if (tc.getSource() == this.rotateActivation) {
            return;
        }
        this.checkNeedTimer(tc);
        SceneGraphPath path = tc.getRootToLocal();
        SceneGraphComponent myComponent = path.getLastComponent();
        Matrix myMatrix = myComponent.getTransformation() != null ? new Matrix(myComponent.getTransformation()) : new Matrix();
        double rot = tc.getAxisState(this.horizontalRotation).doubleValue();
        if (this.rotate && tc.getSource() == this.horizontalRotation) {
            MatrixBuilder.euclidean(myMatrix).rotateY(-rot);
            myMatrix.assignTo(myComponent);
            return;
        }
        if (this.isGravitEnabled()) {
            if (tc.getSource() == this.jump && tc.getAxisState(this.jump).isPressed()) {
                this.velocity[1] = this.jumpSpeed;
            }
        } else {
            this.velocity[1] = 0.0;
        }
        if (tc.getSource() != this.timer) {
            return;
        }
        AxisState axis = tc.getAxisState(this.forwardBackward);
        if (axis != null) {
            this.velocity[2] = this.gain * axis.doubleValue();
        }
        if ((axis = tc.getAxisState(this.leftRight)) != null) {
            this.velocity[0] = -this.gain * axis.doubleValue();
        }
        if (tc.getAxisState(this.run) != null && tc.getAxisState(this.run).isPressed()) {
            this.velocity[0] = this.velocity[0] * this.runFactor;
            this.velocity[2] = this.velocity[2] * this.runFactor;
        }
        if (!this.touchGround || this.velocity[0] != 0.0 || this.velocity[1] != 0.0 || this.velocity[2] != 0.0) {
            double sec = 0.001 * (double)tc.getAxisState(this.timer).intValue();
            double[] trans = new double[]{sec * this.velocity[0], sec * this.velocity[1], sec * this.velocity[2], 1.0};
            double[] dest = myMatrix.multiplyVector(trans);
            Pn.dehomogenize(dest, dest);
            if (myMatrix.containsNanOrInfinite()) {
                System.out.println("NAN!!! 1");
            }
            double[] upDir4 = new double[4];
            if (!this.hasCenter) {
                upDir4 = new double[]{0.0, 1.0, 0.0, 0.0};
            } else {
                Rn.subtract(upDir4, dest, this.center);
                upDir4[3] = 0.0;
                Rn.normalize(upDir4, upDir4);
            }
            if (this.isGravitEnabled()) {
                double h;
                double[] pickStart;
                double[] hit;
                if (!this.fall && (hit = this.getHit(tc, pickStart = Rn.linearCombination(null, 1.0, dest, 1.7, upDir4), dest)) != null) {
                    dest = hit;
                    this.velocity[1] = 0.0;
                    this.touchGround = true;
                }
                double d = h = this.isCenter() ? Math.sqrt(dest[0] * dest[0] + dest[1] * dest[1] + dest[2] * dest[2]) : dest[1];
                if (h < this.minHeight) {
                    if (this.isCenter()) {
                        dest = Rn.times(dest, this.minHeight / h, dest);
                        dest[3] = 1.0;
                    } else {
                        dest[1] = this.minHeight;
                    }
                    this.velocity[1] = 0.0;
                    this.touchGround = true;
                } else {
                    this.velocity[1] = this.velocity[1] - sec * this.gravity;
                    this.touchGround = false;
                }
            }
            if (this.hasCenter) {
                double[] rotateFrom4 = Rn.subtract(null, Pn.dehomogenize(null, myMatrix.getColumn(3)), this.center);
                double[] rotateTo4 = Rn.subtract(null, dest, this.center);
                Matrix rotation = MatrixBuilder.euclidean().rotateFromTo(rotateFrom4, rotateTo4).getMatrix();
                if (!rotation.containsNanOrInfinite()) {
                    myMatrix.multiplyOnLeft(rotation);
                } else {
                    System.out.println("rotation NAN: from=" + Arrays.toString(myMatrix.getColumn(3)) + " to=" + Arrays.toString(dest));
                }
            }
            myMatrix.setColumn(3, dest);
            myMatrix.assignTo(myComponent);
        }
    }

    protected double[] getHit(ToolContext tc, double[] pickStart, double[] dest) {
        if (this.pickDelegate != null && this.pickDelegate.isEnabled()) {
            return this.pickDelegate.getHit(tc, pickStart, dest);
        }
        double[] hit = null;
        List<PickResult> picks = Collections.EMPTY_LIST;
        try {
            picks = tc.getPickSystem().computePick(pickStart, dest);
        }
        catch (Exception e) {
            LoggingSystem.getLogger(this).warning("pick system error");
            return null;
        }
        if (!picks.isEmpty()) {
            PickResult pr = picks.get(0);
            hit = pr.getWorldCoordinates();
        }
        return hit;
    }

    private void checkNeedTimer(ToolContext tc) {
        boolean needTimer = false;
        if (tc.getAxisState(this.forwardBackward) != null && !tc.getAxisState(this.forwardBackward).isReleased()) {
            needTimer = true;
        }
        if (tc.getAxisState(this.leftRight) != null && !tc.getAxisState(this.leftRight).isReleased()) {
            needTimer = true;
        }
        if (tc.getAxisState(this.jump) != null && tc.getAxisState(this.jump).isPressed()) {
            needTimer = true;
        }
        if (needTimer || !this.touchGround) {
            if (!this.timerOnline) {
                this.addCurrentSlot(this.timer);
                this.timerOnline = true;
            }
        } else if (this.timerOnline) {
            this.removeCurrentSlot(this.timer);
            this.timerOnline = false;
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gain) {
        this.gain = gain;
    }

    public double getGravity() {
        return this.gravity;
    }

    public void setGravity(double gravity) {
        this.gravity = gravity;
    }

    public double getJumpSpeed() {
        return this.jumpSpeed;
    }

    public void setJumpSpeed(double jumpSpeed) {
        this.jumpSpeed = jumpSpeed;
    }

    public double getRunFactor() {
        return this.runFactor;
    }

    public void setRunFactor(double runFactor) {
        this.runFactor = runFactor;
    }

    public boolean isCenter() {
        return this.hasCenter;
    }

    public void setCenter(boolean center) {
        this.hasCenter = center;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        if (center.length == 4) {
            Pn.dehomogenize(this.center, center);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.center[i] = center[i];
            }
            this.center[3] = 1.0;
        }
    }

    public boolean isGravitEnabled() {
        return this.gravitEnabled;
    }

    public void setGravitEnabled(boolean gravitEnabled) {
        this.gravitEnabled = gravitEnabled;
    }

    public double getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(double minHeight) {
        this.minHeight = minHeight;
    }

    public PickDelegate getPickDelegate() {
        return this.pickDelegate;
    }

    public void setPickDelegate(PickDelegate pickDelegate) {
        this.pickDelegate = pickDelegate;
    }

    public static interface PickDelegate {
        public double[] getHit(ToolContext var1, double[] var2, double[] var3);

        public boolean isEnabled();
    }
}

