/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.BoundingBoxUtility;
import de.jreality.math.FactoredMatrix;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.P3;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;
import de.jreality.tools.AnimatorTask;
import de.jreality.tools.AnimatorTool;
import de.jreality.util.Rectangle3D;

public class RotateTool
extends AbstractTool {
    static InputSlot activationSlot = InputSlot.getDevice("RotateActivation");
    static InputSlot evolutionSlot = InputSlot.getDevice("TrackballTransformation");
    boolean fixOrigin = false;
    private boolean rotateOnPick = false;
    transient SceneGraphComponent comp;
    transient Matrix center = new Matrix();
    transient EffectiveAppearance eap;
    private transient int metric;
    transient Matrix result = new Matrix();
    transient Matrix evolution = new Matrix();
    private transient double startTime;
    private boolean moveChildren;
    private double animTimeMin = 250.0;
    private double animTimeMax = 750.0;
    private boolean updateCenter;

    public RotateTool() {
        super(activationSlot);
        this.addCurrentSlot(evolutionSlot);
    }

    public void activate(ToolContext tc) {
        this.startTime = tc.getTime();
        this.comp = (this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getLastComponent();
        AnimatorTool.getInstance(tc).deschedule(this.comp);
        if (this.comp.getTransformation() == null) {
            this.comp.setTransformation(new Transformation());
        }
        if (!this.fixOrigin) {
            PickResult currentPick = tc.getCurrentPick();
            this.center = this.rotateOnPick && currentPick != null ? this.getRotationPoint(tc) : this.getCenter(this.comp);
        }
        if (this.eap == null || !EffectiveAppearance.matches(this.eap, tc.getRootToToolComponent())) {
            this.eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        }
        this.metric = this.eap.getAttribute("metric", 0);
    }

    private Matrix getCenter(SceneGraphComponent comp) {
        Matrix centerTranslation = new Matrix();
        Rectangle3D bb = BoundingBoxUtility.calculateChildrenBoundingBox(comp);
        MatrixBuilder.init(null, this.metric).translate(bb.getCenter()).assignTo(centerTranslation);
        return centerTranslation;
    }

    private Matrix getRotationPoint(ToolContext tc) {
        PickResult currentPick = tc.getCurrentPick();
        double[] obj = currentPick.getObjectCoordinates();
        double[] pickMatr = currentPick.getPickPath().getMatrix(null);
        SceneGraphPath compPath = this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent();
        double[] compMatrInv = compPath.getInverseMatrix(null);
        double[] matr = Rn.times(null, compMatrInv, pickMatr);
        double[] rotationPoint = Rn.matrixTimesVector(null, matr, obj);
        Matrix centerTranslation = new Matrix();
        MatrixBuilder.init(null, this.metric).translate(rotationPoint).assignTo(centerTranslation);
        return centerTranslation;
    }

    public void perform(ToolContext tc) {
        Matrix object2avatar = new Matrix((this.moveChildren ? tc.getRootToLocal() : tc.getRootToToolComponent()).getInverseMatrix(null));
        if (Rn.isNan(object2avatar.getArray())) {
            return;
        }
        try {
            object2avatar.assignFrom(P3.extractOrientationMatrix(null, object2avatar.getArray(), P3.originP3, this.metric));
        }
        catch (Exception e) {
            MatrixBuilder.euclidean().assignTo(object2avatar);
        }
        this.evolution.assignFrom(tc.getTransformationMatrix(evolutionSlot));
        this.evolution.conjugateBy(object2avatar);
        if (!this.fixOrigin && this.updateCenter) {
            PickResult currentPick = tc.getCurrentPick();
            this.center = this.rotateOnPick && currentPick != null ? this.getRotationPoint(tc) : this.getCenter(this.comp);
        }
        if (this.metric != 0) {
            P3.orthonormalizeMatrix(this.evolution.getArray(), this.evolution.getArray(), 1.0E-7, this.metric);
        }
        this.result.assignFrom(this.comp.getTransformation());
        if (!this.fixOrigin) {
            this.result.multiplyOnRight(this.center);
        }
        this.result.multiplyOnRight(this.evolution);
        if (!this.fixOrigin) {
            this.result.multiplyOnRight(this.center.getInverse());
        }
        if (Rn.isNan(this.result.getArray())) {
            return;
        }
        this.comp.getTransformation().setMatrix(this.result.getArray());
    }

    public void deactivate(ToolContext tc) {
        double t = (double)tc.getTime() - this.startTime;
        if (t > this.animTimeMin && t < this.animTimeMax) {
            AnimatorTask task = new AnimatorTask(){
                FactoredMatrix e;
                double rotAngle;
                double[] axis;
                Matrix cen;
                SceneGraphComponent c;
                {
                    this.e = new FactoredMatrix(RotateTool.this.evolution, 0);
                    this.rotAngle = this.e.getRotationAngle();
                    this.axis = this.e.getRotationAxis();
                    if (this.rotAngle > Math.PI) {
                        this.rotAngle = Math.PI * -2 + this.rotAngle;
                    }
                    this.cen = new Matrix(RotateTool.this.center);
                    this.c = RotateTool.this.comp;
                }

                public boolean run(double time, double dt) {
                    if (RotateTool.this.updateCenter) {
                        this.cen = RotateTool.this.getCenter(this.c);
                    }
                    MatrixBuilder m = MatrixBuilder.euclidean(this.c.getTransformation());
                    m.times(this.cen);
                    m.rotate(0.05 * dt * this.rotAngle, this.axis);
                    m.times(this.cen.getInverse());
                    m.assignTo(this.c);
                    return true;
                }
            };
            AnimatorTool.getInstance(tc).schedule(this.comp, task);
        }
    }

    public boolean getMoveChildren() {
        return this.moveChildren;
    }

    public void setMoveChildren(boolean moveChildren) {
        this.moveChildren = moveChildren;
    }

    public double getAnimTimeMax() {
        return this.animTimeMax;
    }

    public void setAnimTimeMax(double animTimeMax) {
        this.animTimeMax = animTimeMax;
    }

    public double getAnimTimeMin() {
        return this.animTimeMin;
    }

    public void setAnimTimeMin(double animTimeMin) {
        this.animTimeMin = animTimeMin;
    }

    public boolean isUpdateCenter() {
        return this.updateCenter;
    }

    public void setUpdateCenter(boolean updateCenter) {
        this.updateCenter = updateCenter;
        if (!updateCenter) {
            this.center = new Matrix();
        }
    }

    public boolean isFixOrigin() {
        return this.fixOrigin;
    }

    public void setFixOrigin(boolean fixOrigin) {
        this.fixOrigin = fixOrigin;
    }

    public boolean isRotateOnPick() {
        return this.rotateOnPick;
    }

    public void setRotateOnPick(boolean rotateOnPick) {
        this.rotateOnPick = rotateOnPick;
    }
}

