/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.IndexedLineSetFactory;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.awt.Color;
import java.lang.reflect.Method;

public class PointerDisplayTool
extends AbstractTool {
    protected static final InputSlot AVATAR_POINTER = InputSlot.getDevice("PointerShipTransformation");
    SceneGraphComponent cmp = new SceneGraphComponent();
    private IndexedLineSetFactory ilsf;
    private Color highlightColor = Color.orange;
    private Color defaultColor = new Color(160, 160, 160);
    private transient boolean highlight = false;
    boolean isAssigned;
    private Matrix m = new Matrix();
    private Method getPortalScale;

    public PointerDisplayTool(double radius) {
        super(new InputSlot[0]);
        try {
            this.getPortalScale = Class.forName("de.jreality.portal.PortalCoordinateSystem").getMethod("getPortalScale", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addCurrentSlot(AVATAR_POINTER);
        this.cmp.setAppearance(new Appearance());
        this.cmp.getAppearance().setAttribute("lightingEnabled", false);
        this.cmp.getAppearance().setAttribute("showPoints", false);
        this.cmp.getAppearance().setAttribute("showFaces", false);
        this.cmp.getAppearance().setAttribute("showLines", true);
        this.cmp.getAppearance().setAttribute("lineShader.tubeDraw", true);
        this.cmp.getAppearance().setAttribute("lineShader.tubeRadius", radius);
        this.cmp.setPickable(false);
        this.cmp.setTransformation(new Transformation());
        this.setHighlight(false);
        this.ilsf = new IndexedLineSetFactory();
        this.ilsf.setVertexCount(2);
        this.ilsf.setEdgeCount(1);
        this.ilsf.setEdgeIndices(new int[]{0, 1});
        this.cmp.setGeometry(this.ilsf.getGeometry());
        this.setLength(1.0);
    }

    public PointerDisplayTool() {
        this(0.003);
    }

    public void perform(ToolContext tc) {
        if (!this.isAssigned) {
            tc.getAvatarPath().getLastComponent().addChild(this.cmp);
            this.isAssigned = true;
        }
        this.m.assignFrom(tc.getTransformationMatrix(AVATAR_POINTER));
        try {
            MatrixBuilder.euclidean(this.m).scale((Double)this.getPortalScale.invoke(null, new Object[0])).assignTo(this.m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m.assignTo(this.cmp.getTransformation());
    }

    public void setVisible(boolean v) {
        this.cmp.setVisible(v);
    }

    public boolean isVisible() {
        return this.cmp.isVisible();
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public void setHighlight(boolean highlight) {
        this.highlight = highlight;
        this.cmp.getAppearance().setAttribute("diffuseColor", highlight ? this.getHighlightColor() : this.getDefaultColor());
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = defaultColor;
    }

    public void setLength(double l) {
        this.ilsf.setVertexCoordinates(new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, -l}});
        this.ilsf.update();
    }
}

