/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.geometry.Primitives;
import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.awt.Color;

public class PickShowTool
extends AbstractTool {
    private transient SceneGraphComponent c = new SceneGraphComponent();
    private transient Appearance a = new Appearance();
    private transient boolean attached;
    private double radius = 0.005;

    public PickShowTool(String activationAxis, double radius) {
        super(activationAxis == null ? null : InputSlot.getDevice(activationAxis));
        this.radius = radius;
        this.init();
    }

    private void init() {
        this.addCurrentSlot(InputSlot.getDevice("PointerTransformation"));
        this.c.addChild(Primitives.sphere(1.0, 0.0, 0.0, 0.0));
        this.c.setName("pick display");
        this.c.setAppearance(this.a);
        this.c.setPickable(false);
        this.a.setAttribute("showFaces", true);
        this.a.setAttribute("pickable", false);
    }

    public PickShowTool() {
        super(new InputSlot[0]);
        this.init();
    }

    public void activate(ToolContext tc) {
        this.perform(tc);
    }

    public void perform(ToolContext tc) {
        PickResult pr = tc.getCurrentPick();
        if (pr == null) {
            this.assureDetached(tc);
            return;
        }
        this.assureAttached(tc);
        switch (pr.getPickType()) {
            case 1: {
                this.c.getAppearance().setAttribute("diffuseColor", Color.yellow);
                break;
            }
            case 2: {
                this.c.getAppearance().setAttribute("diffuseColor", Color.green);
                break;
            }
            case 4: {
                this.c.getAppearance().setAttribute("diffuseColor", Color.magenta);
                break;
            }
            case 0: {
                this.c.getAppearance().setAttribute("diffuseColor", Color.red);
                break;
            }
            default: {
                this.c.getAppearance().setAttribute("diffuseColor", Color.black);
            }
        }
        double[] worldCoordinates = pr.getWorldCoordinates();
        if (!Pn.isValidCoordinate(worldCoordinates, 3, 0)) {
            return;
        }
        double[] cp = new Matrix(tc.getViewer().getCameraPath().getMatrix(null)).getColumn(3);
        double scale = Rn.euclideanDistance(cp, worldCoordinates);
        MatrixBuilder.euclidean().translate(worldCoordinates).assignTo(this.c);
        MatrixBuilder.euclidean().scale(scale * this.radius).assignTo(this.c.getChildComponent(0));
    }

    public void deactivate(ToolContext tc) {
        this.assureDetached(tc);
    }

    private void assureAttached(ToolContext tc) {
        if (!this.attached) {
            tc.getViewer().getSceneRoot().addChild(this.c);
        }
        this.attached = true;
        this.c.setVisible(true);
    }

    private void assureDetached(ToolContext tc) {
        this.c.setVisible(false);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }
}

