/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.shader.EffectiveAppearance;

public class LookAtTool
extends AbstractTool {
    private InputSlot myActivation = InputSlot.getDevice("ShipRotateActivation");
    private final InputSlot verticalRotation = InputSlot.getDevice("VerticalHeadRotationAngleEvolution");
    private final InputSlot horizontalRotation = InputSlot.getDevice("HorizontalShipRotationAngleEvolution");
    private double currentAngleH;
    private double currentAngleV;
    private double minHorizontalAngle = -1.7976931348623157E308;
    private double maxHorizontalAngle = Double.MAX_VALUE;
    private double minVerticalAngle = -0.2;
    private double maxVerticalAngle = -1.7707963267948965;
    private double rodLength = 5.0;
    private boolean rotate;

    public LookAtTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.myActivation);
        this.currentAngleV = (this.maxVerticalAngle + this.minVerticalAngle) / 2.0;
    }

    public void perform(ToolContext tc) {
        if (this.rotate) {
            if (!tc.getAxisState(this.myActivation).isPressed()) {
                this.removeCurrentSlot(this.verticalRotation);
                this.removeCurrentSlot(this.horizontalRotation);
                this.rotate = false;
            }
        } else if (tc.getAxisState(this.myActivation).isPressed()) {
            this.addCurrentSlot(this.verticalRotation);
            this.addCurrentSlot(this.horizontalRotation);
            this.rotate = true;
        }
        if (tc.getSource() == this.myActivation) {
            return;
        }
        double dAngle = tc.getAxisState(this.verticalRotation).doubleValue();
        double hAngle = tc.getAxisState(this.horizontalRotation).doubleValue();
        if (this.currentAngleH - hAngle <= this.maxHorizontalAngle && this.currentAngleH - hAngle >= this.minHorizontalAngle) {
            this.currentAngleH -= hAngle;
        }
        if (this.currentAngleV + dAngle <= Math.max(this.minVerticalAngle, this.maxVerticalAngle) && this.currentAngleV + dAngle >= Math.min(this.minVerticalAngle, this.maxVerticalAngle)) {
            this.currentAngleV += dAngle;
        }
        EffectiveAppearance eap = EffectiveAppearance.create(tc.getRootToToolComponent());
        int sig = eap.getAttribute("metric", 0);
        Matrix m = MatrixBuilder.init(null, sig).rotateY(this.currentAngleH).rotateX(this.currentAngleV).translate(0.0, 0.0, this.rodLength).getMatrix();
        m.assignTo(tc.getRootToLocal().getLastComponent());
    }

    public double getMaxHorizontalAngle() {
        return this.maxHorizontalAngle;
    }

    public void setMaxHorizontalAngle(double maxHorizontalAngle) {
        this.maxHorizontalAngle = maxHorizontalAngle;
    }

    public double getMaxVerticalAngle() {
        return this.maxVerticalAngle;
    }

    public void setMaxVerticalAngle(double maxVerticalAngle) {
        this.maxVerticalAngle = maxVerticalAngle;
    }

    public double getMinHorizontalAngle() {
        return this.minHorizontalAngle;
    }

    public void setMinHorizontalAngle(double minHorizontalAngle) {
        this.minHorizontalAngle = minHorizontalAngle;
    }

    public double getMinVerticalAngle() {
        return this.minVerticalAngle;
    }

    public void setMinVerticalAngle(double minVerticalAngle) {
        this.minVerticalAngle = minVerticalAngle;
    }

    public double getRodLength() {
        return this.rodLength;
    }

    public void setRodLength(double rodLength) {
        this.rodLength = rodLength;
    }
}

