/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.Matrix;
import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphNode;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.util.SceneGraphUtility;
import java.util.List;

public class DuplicateTriplyPeriodicTool
extends AbstractTool {
    private double[] latticeSpacing;
    private double[] center;
    private int count = 0;

    public DuplicateTriplyPeriodicTool(double latticeX, double latticeY, double latticeZ, double centerX, double centerY, double centerZ) {
        super(InputSlot.getDevice("Duplication"));
        this.latticeSpacing = new double[]{latticeX, latticeY, latticeZ};
        this.center = new double[]{centerX, centerY, centerZ};
    }

    public void activate(ToolContext tc) {
        PickResult pick = tc.getCurrentPick();
        double[] coords = pick.getObjectCoordinates();
        SceneGraphComponent domain = tc.getRootToToolComponent().getLastComponent();
        List<SceneGraphNode> rootToLocal = tc.getRootToLocal().toList();
        int n = rootToLocal.size();
        int j = n - 3;
        while (!SceneGraphUtility.getPathsBetween(domain, rootToLocal.get(j)).isEmpty()) {
            --j;
        }
        SceneGraphComponent copy = (SceneGraphComponent)rootToLocal.get(j);
        Matrix m = new Matrix(tc.getRootToLocal().getMatrix(new Matrix().getArray(), j + 1, n - 1));
        coords = m.multiplyVector(coords);
        for (int i = 0; i < 3; ++i) {
            coords[i] = (coords[i] - this.center[i]) / this.latticeSpacing[i];
        }
        int dir = 0;
        if (Math.abs(coords[1]) > Math.abs(coords[0])) {
            dir = 1;
        }
        if (Math.abs(coords[2]) > Math.abs(coords[dir])) {
            dir = 2;
        }
        double[] trans = new double[3];
        trans[dir] = Math.signum(coords[dir]) * this.latticeSpacing[dir];
        SceneGraphComponent newCopy = new SceneGraphComponent();
        newCopy.setName("copy" + this.count);
        ++this.count;
        MatrixBuilder.euclidean().translate(trans).assignTo(newCopy);
        newCopy.addChild(domain);
        copy.addChild(newCopy);
    }
}

