/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.MatrixBuilder;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import de.jreality.tools.AnimatorTask;
import de.jreality.tools.AnimatorTool;

public class AnimatedRotateTool
extends AbstractTool {
    private static InputSlot actSlot = InputSlot.getDevice("SystemTime");
    private static InputSlot deactSlot = InputSlot.getDevice("PrimarySelection");
    private static InputSlot pause = InputSlot.getDevice("RotationToggle");
    private double angle = 0.007;
    private double[] axis = new double[]{0.0, 1.0, 0.0};
    private AnimatorTask task = null;
    private SceneGraphComponent cmp = null;

    public AnimatedRotateTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(actSlot, "Need notification to perform once.");
        this.addCurrentSlot(pause);
        this.addCurrentSlot(deactSlot);
    }

    public void perform(ToolContext tc) {
        if (this.task == null) {
            this.cmp = tc.getRootToToolComponent().getLastComponent();
            this.task = new AnimatorTask(){

                public boolean run(double time, double dt) {
                    MatrixBuilder m = MatrixBuilder.euclidean(AnimatedRotateTool.this.cmp.getTransformation());
                    m.rotate(0.05 * dt * AnimatedRotateTool.this.angle, AnimatedRotateTool.this.axis);
                    m.assignTo(AnimatedRotateTool.this.cmp);
                    return true;
                }
            };
            this.removeCurrentSlot(actSlot);
        }
        if (tc.getAxisState(deactSlot).isPressed()) {
            this.removeCurrentSlot(deactSlot);
            this.removeCurrentSlot(pause);
            AnimatorTool.getInstance(tc).deschedule(this.cmp);
            this.cmp.removeTool(this);
            return;
        }
        if (tc.getAxisState(pause).isReleased()) {
            AnimatorTool.getInstance(tc).schedule(this.cmp, this.task);
        }
        if (tc.getAxisState(pause).isPressed()) {
            AnimatorTool.getInstance(tc).deschedule(this.cmp);
        }
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double[] getAxis() {
        return this.axis;
    }

    public void setAxis(double[] axis) {
        this.axis = axis;
    }

    public void setAxis(double x, double y, double z) {
        this.axis = new double[]{x, y, z};
    }

    public String getDescription() {
        return "Instantly starts an animated rotation of a SceneGraphComponent after initialization of the tool system when it is added to the components tools. The rotation angle and axis can be set using the corresponding methods. The animation stops with a right mouse click.";
    }
}

