/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.tools;

import de.jreality.math.MatrixBuilder;
import de.jreality.math.Rn;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Transformation;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;

public class AirplaneTool
extends AbstractTool {
    private final transient InputSlot forwardBackward = InputSlot.getDevice("ForwardBackwardAxis");
    private final transient InputSlot leftRight = InputSlot.getDevice("LeftRightAxis");
    private final transient InputSlot slower = InputSlot.getDevice("DecreaseSpeed");
    private final transient InputSlot faster = InputSlot.getDevice("IncreaseSpeed");
    private final transient InputSlot timer = InputSlot.getDevice("SystemTime");
    private final transient InputSlot aBurner = InputSlot.getDevice("JumpActivation");
    private double thrustFactor = 0.01;
    private boolean upDownInvert = false;
    private double runFactor = 2.0;
    private double rollSpeed = 0.002;
    private double rollUpDownSpeed = 5.0E-4;
    private double thrustHesitation = 50.0;
    private double thrust = 0.0;
    private transient double velocity = 0.0;
    private SceneGraphPath toolPath;
    private SceneGraphComponent comp;
    private long timeStamp;
    private boolean afterburner = false;
    private double rollLeftRight = 0.0;
    private double rollUpDown = 0.0;
    private double changeThrust = 0.0;

    public AirplaneTool() {
        super(new InputSlot[0]);
        this.addCurrentSlot(this.timer);
        this.addCurrentSlot(this.forwardBackward);
        this.addCurrentSlot(this.leftRight);
        this.addCurrentSlot(this.aBurner);
        this.addCurrentSlot(this.faster);
        this.addCurrentSlot(this.slower);
        this.setDescription("Fly like an airplane (no gravity)");
        this.setDescription(this.timer, "");
        this.setDescription(this.forwardBackward, "Nose up & down");
        this.setDescription(this.leftRight, "roll left & right");
        this.setDescription(this.aBurner, "afterburner(multiple Speed)");
        this.setDescription(this.slower, "decrease thrust");
        this.setDescription(this.faster, "increase thrust");
    }

    public void activate(ToolContext tc) {
        this.timeStamp = tc.getTime();
    }

    public void perform(ToolContext tc) {
        double dt = tc.getTime() - this.timeStamp;
        this.toolPath = tc.getRootToToolComponent();
        this.comp = this.toolPath.getLastComponent();
        if (this.comp.getTools() == null) {
            this.comp.setTransformation(new Transformation());
        }
        this.afterburner = tc.getAxisState(this.aBurner).isPressed();
        this.changeThrust = 0.0;
        if (tc.getAxisState(this.slower).isPressed()) {
            this.changeThrust -= 1.0;
        }
        if (tc.getAxisState(this.faster).isPressed()) {
            this.changeThrust += 1.0;
        }
        this.rollUpDown = tc.getAxisState(this.forwardBackward).doubleValue();
        this.rollLeftRight = tc.getAxisState(this.leftRight).doubleValue();
        if (this.upDownInvert) {
            this.rollUpDown *= -1.0;
        }
        this.thrust += dt * 0.001 * this.changeThrust;
        if (this.thrust < -1.0) {
            this.thrust = -1.0;
        }
        if (this.thrust > 1.0) {
            this.thrust = 1.0;
        }
        double trueThrust = this.thrust * this.thrustFactor;
        if (this.afterburner) {
            trueThrust = this.runFactor * this.thrustFactor;
        }
        this.velocity += (trueThrust - this.velocity) / this.thrustHesitation;
        if (this.velocity <= 0.0) {
            this.thrust = Math.max(0.0, this.thrust);
            this.velocity = 0.0;
        }
        double[] moveMatrix = MatrixBuilder.euclidean().rotate(dt * this.rollSpeed * this.rollLeftRight, 0.0, 0.0, 1.0).rotate(dt * this.rollUpDownSpeed * this.rollUpDown, 1.0, 0.0, 0.0).translate(0.0, 0.0, -dt * this.velocity).getArray();
        double[] newMatrix = Rn.times(null, this.comp.getTransformation().getMatrix(), moveMatrix);
        this.comp.getTransformation().setMatrix(newMatrix);
        this.timeStamp = (long)((double)this.timeStamp + dt);
    }

    public double getRollSpeed() {
        return this.rollSpeed * 500.0;
    }

    public void setRollSpeed(double rollSpeed) {
        this.rollSpeed = rollSpeed / 500.0;
    }

    public double getRollUpDownSpeed() {
        return this.rollUpDownSpeed * 1000.0;
    }

    public void setRollUpDownSpeed(double rollUpDownSpeed) {
        this.rollUpDownSpeed = rollUpDownSpeed / 1000.0;
    }

    public double getRunFactor() {
        return this.runFactor;
    }

    public void setRunFactor(double runFactor) {
        this.runFactor = runFactor;
    }

    public double getThrustFactor() {
        return this.thrustFactor;
    }

    public void setThrustFactor(double thrustFactor) {
        this.thrustFactor = thrustFactor;
    }

    public double getThrustHesitation() {
        return this.thrustHesitation;
    }

    public void setThrustHesitation(double thrustHesitation) {
        this.thrustHesitation = thrustHesitation;
    }

    public boolean isUpDownInvert() {
        return this.upDownInvert;
    }

    public void setUpDownInvert(boolean upDownInvert) {
        this.upDownInvert = upDownInvert;
    }
}

