/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing.jrwindows;

import de.jreality.math.MatrixBuilder;
import de.jreality.math.Pn;
import de.jreality.math.Rn;
import de.jreality.scene.Appearance;
import de.jreality.scene.Geometry;
import de.jreality.scene.SceneGraphComponent;
import de.jreality.swing.jrwindows.JRWindow;
import de.jreality.tools.DragEventTool;
import de.jreality.tools.FaceDragEvent;
import de.jreality.tools.FaceDragListener;
import de.jreality.tools.PointDragEvent;
import de.jreality.tools.PointDragListener;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

public class JRWindowManager
implements ActionListener {
    private final double[] defaultDesktopWindowPos = new double[]{0.0, 0.0, -2.0};
    private SceneGraphComponent sgc;
    private ArrayList<JRWindow> windowList = new ArrayList();
    private DragEventTool dragTool;
    private boolean windowsInScene = true;

    public JRWindowManager(SceneGraphComponent avatar) {
        this.sgc = new SceneGraphComponent("window manager");
        this.sgc.setAppearance(new Appearance());
        this.sgc.getAppearance().setAttribute("lightingEnabled", false);
        this.sgc.getAppearance().setAttribute("metric", 0);
        this.sgc.getAppearance().setAttribute("polygonShader.reflectionMap:blendColor", new Color(255, 255, 255, 65));
        this.sgc.getAppearance().setAttribute("lineShader.polygonShader.reflectionMap:blendColor", new Color(255, 255, 255, 255));
        avatar.addChild(this.sgc);
        this.setPosition(this.defaultDesktopWindowPos);
        this.initDragTool();
    }

    private void initDragTool() {
        this.dragTool = new DragEventTool("PrimaryAction");
        this.dragTool.addPointDragListener(new PointDragListener(){
            private int windowNum;
            private int cornerIndex;

            public void pointDragStart(PointDragEvent e) {
                this.windowNum = JRWindowManager.this.searchWindowNum(e.getPointSet());
                if (this.windowNum == -1) {
                    return;
                }
                if (((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).isSmall()) {
                    return;
                }
                this.cornerIndex = e.getIndex();
                JRWindowManager.this.setWindowInFront(this.windowNum);
                ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).setVertexDragged(true);
            }

            public void pointDragged(PointDragEvent e) {
                if (this.windowNum == -1) {
                    return;
                }
                if (((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).isSmall()) {
                    return;
                }
                double[] point = new double[3];
                point[0] = e.getPosition()[0];
                point[1] = e.getPosition()[1];
                ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).setCorner(this.cornerIndex, point);
            }

            public void pointDragEnd(PointDragEvent e) {
                ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).popUpDragVertices(false);
                ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).setVertexDragged(false);
            }
        });
        this.dragTool.addFaceDragListener(new FaceDragListener(){
            private int windowNum;
            private double[][] points;

            public void faceDragStart(FaceDragEvent e) {
                this.windowNum = JRWindowManager.this.searchWindowNum(e.getIndexedFaceSet());
                if (this.windowNum == -1) {
                    return;
                }
                JRWindowManager.this.setWindowInFront(this.windowNum);
                this.points = ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).getCornerPos();
            }

            public void faceDragged(FaceDragEvent e) {
                if (this.windowNum == -1) {
                    return;
                }
                double[] translation = e.getTranslation();
                double[][] newPoints = new double[this.points.length][this.points[0].length];
                Pn.dehomogenize(translation, translation);
                translation[2] = 0.0;
                if (translation.length == 4) {
                    translation[3] = 0.0;
                }
                for (int i = 0; i < this.points.length; ++i) {
                    Rn.add(newPoints[i], this.points[i], translation);
                }
                ((JRWindow)JRWindowManager.this.windowList.get(this.windowNum)).setCornerPos(newPoints);
            }

            public void faceDragEnd(FaceDragEvent e) {
            }
        });
        this.sgc.addTool(this.dragTool);
    }

    private int searchWindowNum(Geometry matchedGeo) {
        int matchedWindowNum = 0;
        for (JRWindow win : this.windowList) {
            if (matchedGeo.equals(win.getFrameFace()) || matchedGeo.equals(win.getBorders()) || matchedGeo.equals(win.getDecoDragFace())) {
                return matchedWindowNum;
            }
            ++matchedWindowNum;
        }
        return -1;
    }

    private void setWindowInFront(int windowNum) {
        int i = 0;
        for (JRWindow win : this.windowList) {
            if (i == windowNum) {
                win.setInFront(true);
            } else {
                win.setInFront(false);
            }
            ++i;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().startsWith("O")) {
            String command = e.getActionCommand();
            int windowNum = Integer.parseInt(command = command.replaceFirst(String.valueOf(command.charAt(0)), ""));
            if (this.windowList.get(windowNum).isSmall()) {
                this.windowList.get(windowNum).setSmall(false);
                this.setWindowInFront(windowNum);
            }
        } else if (e.getActionCommand().startsWith("_")) {
            String command = e.getActionCommand();
            int windowNum = Integer.parseInt(command = command.replaceFirst(String.valueOf(command.charAt(0)), ""));
            if (!this.windowList.get(windowNum).isSmall()) {
                this.windowList.get(windowNum).setSmall(true);
            }
        }
    }

    public JRWindow createFrame() {
        JRWindow window = new JRWindow(this.getWindowCount());
        window.addActionListeners(this);
        window.setInScene(this.getWindowsInScene());
        this.sgc.addChild(window.getSgc());
        this.windowList.add(window);
        this.setWindowInFront(this.getWindowCount() - 1);
        return window;
    }

    public boolean getWindowsInScene() {
        return this.windowsInScene;
    }

    public void setWindowsInScene(boolean b) {
        this.windowsInScene = b;
        for (JRWindow w : this.windowList) {
            w.setInScene(this.windowsInScene);
        }
    }

    public int getWindowCount() {
        return this.windowList.size();
    }

    public void setPosition(double[] pos) {
        MatrixBuilder.euclidean().translate(pos).assignTo(this.sgc);
    }

    public void enableVertexPopUpTool(boolean enableVertexPopUpTool) {
        for (JRWindow w : this.windowList) {
            w.enableVertexPopUpTool(enableVertexPopUpTool);
        }
    }

    public SceneGraphComponent getSceneGraphRepresentation() {
        return this.sgc;
    }
}

