/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.scene.Geometry;
import de.jreality.scene.pick.PickResult;
import de.jreality.scene.tool.AbstractTool;
import de.jreality.scene.tool.InputSlot;
import de.jreality.scene.tool.ToolContext;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.MouseEvent;

class MouseEventTool
extends AbstractTool {
    private Point oldPoint;
    private Component comp;
    private Geometry current;
    private static InputSlot drag0 = InputSlot.getDevice("PanelAction");
    private static InputSlot drag2 = InputSlot.getDevice("PanelSelection");
    private static InputSlot drag1 = InputSlot.getDevice("PanelMenu");
    private int width;
    private int height;
    private boolean dispatchLater = true;
    long lastActivationTime;
    int currentButton = 0;
    boolean doubleClick;
    int doubleClickDelay = 400;

    public MouseEventTool(Component c, boolean dispatchLater) {
        super(drag0, drag1, drag2);
        this.comp = c;
        this.dispatchLater = dispatchLater;
        this.addCurrentSlot(InputSlot.getDevice("PointerTransformation"), "moves the mouse pointer");
    }

    public MouseEventTool(Component c) {
        this(c, true);
    }

    public void activate(ToolContext e) {
        Point newPoint;
        PickResult currentPick = e.getCurrentPick();
        try {
            this.current = (Geometry)currentPick.getPickPath().getLastElement();
        }
        catch (Exception ex) {
            // empty catch block
        }
        int lastButton = this.currentButton;
        if (e.getSource() == drag0) {
            this.currentButton = 0;
        }
        if (e.getSource() == drag1) {
            this.currentButton = 1;
        }
        if (e.getSource() == drag2) {
            this.currentButton = 2;
        }
        long t = System.currentTimeMillis();
        if (lastButton == this.currentButton && t - this.lastActivationTime <= (long)this.doubleClickDelay) {
            this.doubleClick = true;
            this.lastActivationTime = 0L;
        } else {
            this.lastActivationTime = t;
            this.doubleClick = false;
        }
        this.oldPoint = newPoint = this.generatePoint(currentPick);
        this.dispatchMouseEvent(newPoint, 501, this.currentButton);
    }

    public void perform(ToolContext e) {
        try {
            PickResult currentPick = e.getCurrentPick();
            if (currentPick != null && this.current == (Geometry)currentPick.getPickPath().getLastElement()) {
                Point newPoint = this.generatePoint(currentPick);
                this.dispatchMouseEvent(newPoint, 506, this.currentButton);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deactivate(ToolContext e) {
        PickResult currentPick = e.getCurrentPick();
        boolean sameGeom = currentPick != null && this.current == (Geometry)currentPick.getPickPath().getLastElement();
        Point newPoint = sameGeom ? this.generatePoint(currentPick) : null;
        this.dispatchMouseEvent(sameGeom ? newPoint : this.oldPoint, 502, this.currentButton);
        if (this.oldPoint.equals(newPoint)) {
            this.dispatchMouseEvent(newPoint, 500, this.currentButton);
        }
        this.current = null;
    }

    private Point generatePoint(PickResult pr) {
        Point newPoint = null;
        if (pr != null) {
            double[] tc = pr.getTextureCoordinates();
            if (tc == null || tc.length < 2) {
                tc = pr.getObjectCoordinates();
                newPoint = new Point((int)((1.0 - tc[0]) * (double)this.width), (int)((1.0 - tc[1]) * (double)this.height));
            } else {
                newPoint = new Point((int)(tc[0] * (double)this.width), (int)(tc[1] * (double)this.height));
            }
        } else {
            newPoint = new Point(0, 0);
        }
        return newPoint;
    }

    void dispatchMouseEvent(Point newPoint, int type, int button) {
        MouseEvent newEvent = new MouseEvent(this.comp, type, System.currentTimeMillis(), 1 << 10 + button, newPoint.x, newPoint.y, this.doubleClick ? 2 : 1, false, 1 + button);
        this.dispatchEvent(newEvent);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void dispatchEvent(final AWTEvent e) {
        if (this.dispatchLater) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    MouseEventTool.this.comp.dispatchEvent(e);
                }
            });
        } else {
            this.comp.dispatchEvent(e);
        }
    }
}

