/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.swing;

import de.jreality.swing.FakeToolKit;
import de.jreality.swing.FakeVolatileImage;
import de.jreality.swing.JFakeFrame;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ContainerPeer;

class FakeFramePeer {
    private static final boolean DUMP = false;
    private BufferedImage bi;
    private VolatileImage vi;
    private JFakeFrame frame;
    private Runnable repaintAction;
    Rectangle bounds;
    private Image backBuffer;
    int state = 0;

    FakeFramePeer(JFakeFrame f) {
        this.frame = f;
        Dimension d = f.getSize();
        if (d.width == 0) {
            d.width = 1;
        }
        if (d.height == 0) {
            d.height = 1;
        }
        this.bounds = new Rectangle(d.width, d.height);
        this.bi = new BufferedImage(d.width, d.height, 2);
        this.backBuffer = new BufferedImage(d.width, d.height, 2);
        this.vi = new FakeVolatileImage(this.bi);
    }

    public void endLayout() {
        this.frame.paint(this.bi.getGraphics());
        if (this.repaintAction != null) {
            this.repaintAction.run();
        }
    }

    public void endValidate() {
        this.frame.paint(this.bi.getGraphics());
        if (this.repaintAction != null) {
            this.repaintAction.run();
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Insets insets() {
        return new Insets(0, 0, 0, 0);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean moved;
        boolean resized = width != this.bounds.width || height != this.bounds.height;
        boolean bl = moved = x != this.bounds.x || y != this.bounds.y;
        if (resized) {
            this.bi = new BufferedImage(Math.max(1, width), Math.max(1, height), 2);
            this.vi = new FakeVolatileImage(this.bi);
            this.backBuffer = new BufferedImage(Math.max(1, width), Math.max(1, height), 2);
        }
        if (resized || moved) {
            this.bounds.setBounds(x, y, width, height);
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return new Dimension(256, 256);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Graphics getGraphics() {
        if (this.repaintAction != null) {
            EventQueue.invokeLater(this.repaintAction);
        }
        return this.bi.createGraphics();
    }

    public void paint(Graphics g) {
        g.drawImage(this.bi, 0, 0, null);
    }

    public void print(Graphics g) {
        g.drawImage(this.bi, 0, 0, null);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.frame.getGraphicsConfiguration();
    }

    public Image createImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public Point getLocationOnScreen() {
        Point ret = new Point(this.bounds.x, this.bounds.y);
        return ret;
    }

    public Toolkit getToolkit() {
        return FakeToolKit.getDefaultToolkit();
    }

    public void coalescePaintEvent(PaintEvent e) {
        this.frame.paint(this.bi.getGraphics());
        if (this.repaintAction != null) {
            this.repaintAction.run();
        }
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public VolatileImage createVolatileImage(int width, int height) {
        return this.vi;
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Image createImage(ImageProducer producer) {
        return Toolkit.getDefaultToolkit().createImage(producer);
    }

    public BufferedImage getRootImage() {
        return this.bi;
    }

    public void setRepaintAction(Runnable r) {
        this.repaintAction = r;
    }

    public boolean requestWindowFocus() {
        return true;
    }

    public void setBounds(int x, int y, int width, int height, int op) {
        this.setBounds(x, y, width, height);
    }

    public int getState() {
        return this.state;
    }

    public void setBoundsPrivate(int x, int y, int width, int height) {
    }

    public void setIconImage(Image im) {
    }

    public void setMaximizedBounds(Rectangle bounds) {
    }

    public void setMenuBar(MenuBar mb) {
    }

    public void setResizable(boolean resizeable) {
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setTitle(String title) {
    }

    public void toBack() {
    }

    public void toFront() {
    }

    public void updateAlwaysOnTop() {
    }

    public void updateFocusableWindowState() {
    }

    public void beginLayout() {
    }

    public void beginValidate() {
    }

    public void cancelPendingPaint(int x, int y, int w, int h) {
    }

    public boolean isPaintPending() {
        return false;
    }

    public boolean isRestackSupported() {
        return false;
    }

    public void restack() {
    }

    public boolean canDetermineObscurity() {
        return false;
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return 0;
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
    }

    public void destroyBuffers() {
    }

    public void disable() {
    }

    public void dispose() {
    }

    public void enable() {
    }

    public void flip(BufferCapabilities.FlipContents flipAction) {
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public void handleEvent(AWTEvent e) {
    }

    public boolean handlesWheelScrolling() {
        return false;
    }

    public void hide() {
        this.frame.setMute(true);
    }

    public boolean isFocusable() {
        return false;
    }

    public boolean isObscured() {
        return false;
    }

    public boolean isReparentSupported() {
        return false;
    }

    public void layout() {
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return false;
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void reparent(ContainerPeer newContainer) {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        return false;
    }

    public void reshape(int x, int y, int width, int height) {
    }

    public void setBackground(Color c) {
    }

    public void setEnabled(boolean b) {
    }

    public void setFont(Font f) {
    }

    public void setForeground(Color c) {
    }

    public void setVisible(boolean b) {
    }

    public void show() {
        this.frame.setMute(false);
    }

    public void updateCursorImmediately() {
    }
}

