/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.primitive;

import de.jreality.backends.texture.EnvironmentTexture;
import de.jreality.shader.CubeMap;
import org.sunflow.SunflowAPI;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Ray;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.OrthoNormalBasis;
import org.sunflow.math.Vector3;

public class SkyBox
implements PrimitiveList,
Shader {
    private OrthoNormalBasis basis;
    private EnvironmentTexture envTex;

    public SkyBox(CubeMap cm) {
        this.updateBasis(new Vector3(0.0f, 0.0f, -1.0f), new Vector3(0.0f, 1.0f, 0.0f));
        this.envTex = new EnvironmentTexture(cm, null);
    }

    public int getNumPrimitives() {
        return 1;
    }

    public float getPrimitiveBound(int primID, int i) {
        return 0.0f;
    }

    public BoundingBox getWorldBounds(Matrix4 o2w) {
        return null;
    }

    public void intersectPrimitive(Ray r, int primID, IntersectionState state) {
        if (r.getMax() == Float.POSITIVE_INFINITY) {
            state.setIntersection(0, 0.0f, 0.0f);
        }
    }

    public void prepareShadingState(ShadingState state) {
        if (state.includeLights()) {
            state.setShader((Shader)this);
        }
    }

    public boolean update(ParameterList pl, SunflowAPI api) {
        this.updateBasis(pl.getVector("center", null), pl.getVector("up", null));
        return true;
    }

    public void init(String name, SunflowAPI api) {
        api.geometry(name, (PrimitiveList)this);
        api.shader(name + ".shader", (Shader)this);
        api.parameter("shaders", name + ".shader");
        api.instance(name + ".instance", name);
    }

    public Color getRadiance(ShadingState state) {
        return state.includeLights() ? this.getColor(this.basis.untransform(state.getRay().getDirection(), new Vector3())) : Color.BLACK;
    }

    public void scatterPhoton(ShadingState state, Color power) {
    }

    private Color getColor(Vector3 dir) {
        double[] color = new double[4];
        this.envTex.getColor(0.0, 0.0, dir.x, dir.y, dir.z, 0, 0, color);
        return new Color((float)(color[0] / 255.0), (float)(color[1] / 255.0), (float)(color[2] / 255.0)).toLinear().mul(3.14f);
    }

    private void updateBasis(Vector3 center, Vector3 up) {
        if (center != null && up != null) {
            this.basis = OrthoNormalBasis.makeFromWV((Vector3)center, (Vector3)up);
            this.basis.swapWU();
            this.basis.flipV();
        }
    }

    public PrimitiveList getBakingPrimitives() {
        return null;
    }
}

