/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow.core.light;

import org.sunflow.SunflowAPI;
import org.sunflow.core.LightSample;
import org.sunflow.core.LightSource;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Ray;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;

public class GlPointLight
implements LightSource {
    private Point3 lightPoint = new Point3(0.0f, 0.0f, 0.0f);
    private Color power = Color.WHITE;
    private float fallOffA0 = 0.0f;
    private float fallOffA1 = 0.0f;
    private float fallOffA2 = 1.0f;

    public boolean update(ParameterList pl, SunflowAPI api) {
        this.lightPoint = pl.getPoint("center", this.lightPoint);
        this.power = pl.getColor("power", this.power);
        this.fallOffA0 = pl.getFloat("fallOffA0", 0.0f);
        this.fallOffA1 = pl.getFloat("fallOffA1", 0.0f);
        this.fallOffA2 = pl.getFloat("fallOffA2", 1.0f);
        return true;
    }

    public int getNumSamples() {
        return 1;
    }

    public int getLowSamples() {
        return 1;
    }

    public boolean isVisible(ShadingState state) {
        Point3 p = state.getPoint();
        Vector3 n = state.getNormal();
        return (double)Vector3.dot((Vector3)Point3.sub((Point3)this.lightPoint, (Point3)p, (Vector3)new Vector3()), (Vector3)n) > 0.0;
    }

    public void getSamples(ShadingState state) {
        LightSample dest = new LightSample();
        dest.setShadowRay(new Ray(state.getPoint(), this.lightPoint));
        float dist = this.lightPoint.distanceTo(state.getPoint());
        float fallOff = this.fallOffA0 + dist * this.fallOffA1 + dist * dist * this.fallOffA2;
        float scale = 1.0f / (float)(Math.PI * 4 * (double)fallOff);
        dest.setRadiance(this.power, this.power);
        dest.getDiffuseRadiance().mul(scale);
        dest.getSpecularRadiance().mul(scale);
        dest.traceShadow(state);
        state.addSample(dest);
    }

    public void getPhoton(double randX1, double randY1, double randX2, double randY2, Point3 p, Vector3 dir, Color power) {
        p.set(this.lightPoint);
        float phi = (float)(Math.PI * 2 * randX1);
        float s = (float)Math.sqrt(randY1 * (1.0 - randY1));
        dir.x = (float)Math.cos(phi) * s;
        dir.y = (float)Math.sin(phi) * s;
        dir.z = (float)(1.0 - 2.0 * randY1);
        power.set(this.power);
    }

    public boolean isAdaptive() {
        return false;
    }

    public float getPower() {
        return this.power.getLuminance();
    }
}

