/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.scene.SceneGraphComponent;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.sunflow.CancelableImagePanel;
import de.jreality.sunflow.RenderOptions;
import de.jreality.sunflow.SunflowRenderer;
import java.awt.Component;
import java.awt.Dimension;
import org.sunflow.core.Display;

public class SunflowViewer
implements Viewer {
    private SceneGraphPath cameraPath;
    private SceneGraphComponent sceneRoot;
    private CancelableImagePanel display = new CancelableImagePanel();
    private int width;
    private int height;
    private RenderOptions options;

    public CancelableImagePanel getViewingComponent() {
        return this.display;
    }

    public void setSceneRoot(SceneGraphComponent c) {
        this.sceneRoot = c;
    }

    public SceneGraphComponent getSceneRoot() {
        return this.sceneRoot;
    }

    public void render() {
        SunflowRenderer sv = new SunflowRenderer();
        sv.setOptions(this.options);
        sv.render(this.sceneRoot, this.cameraPath, (Display)this.display, this.width, this.height, new int[0]);
    }

    public SceneGraphPath getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(SceneGraphPath p) {
        this.cameraPath = p;
    }

    public boolean hasViewingComponent() {
        return false;
    }

    public void initializeFrom(Viewer v) {
        this.cameraPath = v.getCameraPath();
        this.sceneRoot = v.getSceneRoot();
        if (v.hasViewingComponent()) {
            Component c = (Component)v.getViewingComponent();
            this.setWidth(c.getWidth());
            this.setHeight(c.getHeight());
        }
        this.display.setPreferredSize(new Dimension(this.width, this.height));
    }

    public int getMetric() {
        return 0;
    }

    public void setMetric(int sig) {
    }

    public void setAuxiliaryRoot(SceneGraphComponent ar) {
        throw new UnsupportedOperationException("not implemented");
    }

    public SceneGraphComponent getAuxiliaryRoot() {
        throw new UnsupportedOperationException("not implemented");
    }

    public int getHeight() {
        return this.width;
    }

    public void setHeight(int h) {
        this.height = h;
        this.display.setPreferredSize(new Dimension(this.width, this.height));
    }

    public int getWidth() {
        return this.height;
    }

    public void setWidth(int w) {
        this.width = w;
        this.display.setPreferredSize(new Dimension(this.width, this.height));
    }

    public Dimension getViewingComponentSize() {
        return this.getViewingComponent().getSize();
    }

    public boolean canRenderAsync() {
        return false;
    }

    public void renderAsync() {
        throw new UnsupportedOperationException();
    }

    public RenderOptions getOptions() {
        return this.options;
    }

    public void setOptions(RenderOptions options) {
        this.options = options;
    }

    public void cancel() {
        this.display.cancel();
    }
}

