/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.scene.Appearance;
import de.jreality.scene.SceneGraphPath;
import de.jreality.scene.Viewer;
import de.jreality.sunflow.BakingDisplay;
import de.jreality.sunflow.RenderDisplay;
import de.jreality.sunflow.RenderOptions;
import de.jreality.sunflow.SunflowRenderer;
import de.jreality.sunflow.SunflowViewer;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.Expression;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.Statement;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.sunflow.system.UI;
import org.sunflow.system.UserInterface;
import org.sunflow.system.ui.ConsoleInterface;

public class Sunflow {
    private static String[] filters = new String[]{"png", "tga", "hdr"};

    private Sunflow() {
    }

    public static void renderToTexture(final Viewer v, final Dimension dim, final RenderOptions options, final SceneGraphPath bakingPath, final Appearance app) {
        new Thread(new Runnable(){

            public void run() {
                BakingDisplay baker = new BakingDisplay(app);
                UI.set((UserInterface)baker);
                SunflowRenderer renderer = new SunflowRenderer();
                renderer.setOptions(options);
                renderer.render(v.getSceneRoot(), v.getCameraPath(), bakingPath, baker, dim.width, dim.height);
                UI.set((UserInterface)new ConsoleInterface());
            }
        }).start();
    }

    public static void renderAndSave(final Viewer v, final RenderOptions options, final Dimension dim, File file) {
        final RenderDisplay renderDisplay = new RenderDisplay(file.getAbsolutePath());
        new Thread(new Runnable(){

            public void run() {
                SunflowRenderer renderer = new SunflowRenderer();
                renderer.setOptions(options);
                renderer.render(v.getSceneRoot(), v.getCameraPath(), renderDisplay, dim.width, dim.height, new int[0]);
            }
        }).start();
    }

    public static void render(Viewer v, Dimension dim, RenderOptions options) {
        final SunflowViewer viewer = new SunflowViewer();
        viewer.setWidth(dim.width);
        viewer.setHeight(dim.height);
        viewer.setSceneRoot(v.getSceneRoot());
        viewer.setCameraPath(v.getCameraPath());
        viewer.setOptions(options);
        final JFrame frame = new JFrame("Sunflow");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                viewer.cancel();
            }
        });
        frame.setLayout(new BorderLayout());
        JMenuBar bar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new AbstractAction("Save"){
            {
                super(x0);
                this.putValue("ShortDescription", "Save image as a file");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            }

            public void actionPerformed(ActionEvent e) {
                Sunflow.save(viewer, frame);
            }
        });
        bar.add(fileMenu);
        frame.setJMenuBar(bar);
        frame.setContentPane((Container)((Object)viewer.getViewingComponent()));
        frame.pack();
        frame.setVisible(true);
        new Thread(new Runnable(){

            public void run() {
                viewer.render();
            }
        }).start();
    }

    private static void save(SunflowViewer v, JFrame frame) {
        try {
            Class<?> ffClass = Class.forName("de.jreality.ui.viewerapp.FileFilter");
            Class<?> fldClass = Class.forName("de.jreality.ui.viewerapp.FileLoaderDialog");
            FileFilter[] ff = new FileFilter[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                ff[i] = (FileFilter)ffClass.newInstance();
                new Statement(ff[i], "setDescription", new Object[]{filters[i].toUpperCase() + " Image"}).execute();
                new Statement(ff[i], "addExtension", new Object[]{filters[i]}).execute();
            }
            File file = (File)new Expression(fldClass, "selectTargetFile", new Object[]{null, false, ff}).getValue();
            if (file != null) {
                v.getViewingComponent().save(file.getAbsolutePath());
            }
            return;
        }
        catch (Exception e) {
            int choice;
            FileSystemView view = FileSystemView.getFileSystemView();
            final JFileChooser chooser = new JFileChooser(view.getHomeDirectory(), view);
            chooser.setMultiSelectionEnabled(false);
            chooser.setAcceptAllFileFilterUsed(false);
            int i = 0;
            while (i < filters.length) {
                final int ind = i++;
                chooser.addChoosableFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.isDirectory() || f.getName().toLowerCase().endsWith("." + filters[ind]);
                    }

                    public String getDescription() {
                        return filters[ind].toUpperCase() + " Image (*." + filters[ind] + ")";
                    }
                });
            }
            chooser.setFileFilter(chooser.getChoosableFileFilters()[0]);
            chooser.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    try {
                        BasicFileChooserUI ui = (BasicFileChooserUI)chooser.getUI();
                        chooser.setSelectedFile(new File(ui.getFileName()));
                        chooser.updateUI();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            File file = null;
            while ((choice = chooser.showSaveDialog(frame)) == 0) {
                File chosen = chooser.getSelectedFile();
                if (!chosen.exists()) {
                    file = chosen;
                    break;
                }
                int confirm = JOptionPane.showConfirmDialog(frame, "Overwrite file " + chosen.getName() + "?");
                if (confirm == 0) {
                    file = chosen;
                    break;
                }
                if (confirm == 1) continue;
            }
            if (file != null) {
                v.getViewingComponent().save(file.getAbsolutePath());
            }
            return;
        }
    }
}

