/*
 * Decompiled with CFR 0.152.
 */
package de.jreality.sunflow;

import de.jreality.sunflow.CancelableImagePanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.sunflow.core.Display;
import org.sunflow.core.display.FileDisplay;
import org.sunflow.core.display.OpenExrDisplay;
import org.sunflow.image.Color;
import org.sunflow.system.UI;

public class RenderDisplay
implements Display {
    private JFrame frame;
    private CancelableImagePanel imagePanel;
    private Display fileDisplay;

    public RenderDisplay() {
        this(null);
    }

    public RenderDisplay(String filename) {
        if (filename != null) {
            this.fileDisplay = filename.endsWith(".exr") ? new OpenExrDisplay(filename, null, null) : new FileDisplay(filename);
        }
        this.frame = null;
    }

    public void imageBegin(int w, int h, int bucketSize) {
        if (this.fileDisplay != null) {
            this.fileDisplay.imageBegin(w, h, bucketSize);
        }
        if (this.frame == null) {
            this.frame = new JFrame("Sunflow v0.07.2");
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    if (!RenderDisplay.this.imagePanel.isDone() && JOptionPane.showConfirmDialog(RenderDisplay.this.frame, "Really abort all ongoing rendering jobs?", "Sunflow", 0) == 0) {
                        UI.taskCancel();
                    }
                }
            });
            this.imagePanel = new CancelableImagePanel();
            this.imagePanel.imageBegin(w, h, bucketSize);
            Dimension screenRes = Toolkit.getDefaultToolkit().getScreenSize();
            boolean needFit = false;
            double width = w;
            double height = h;
            if ((double)w >= screenRes.getWidth() - 200.0) {
                width = screenRes.getWidth() - 200.0;
                height *= width / (double)w;
                needFit = true;
            }
            if (height >= screenRes.getHeight() - 200.0) {
                double newHeight = screenRes.getHeight() - 200.0;
                width *= newHeight / height;
                height = newHeight;
                needFit = true;
            }
            this.imagePanel.setPreferredSize(new Dimension((int)width, (int)height));
            System.out.println("dimension " + w + ", " + h);
            this.frame.setContentPane((Container)((Object)this.imagePanel));
            this.frame.pack();
            this.frame.setLocationRelativeTo(null);
            this.frame.setVisible(true);
            if (needFit) {
                this.imagePanel.fit();
            }
            this.imagePanel.imageBegin(w, h, bucketSize);
        }
    }

    public void imagePrepare(int x, int y, int w, int h, int id) {
        if (this.fileDisplay != null) {
            this.fileDisplay.imagePrepare(x, y, w, h, id);
        }
        this.imagePanel.imagePrepare(x, y, w, h, id);
    }

    public void imageUpdate(int x, int y, int w, int h, Color[] data) {
        if (this.fileDisplay != null) {
            this.fileDisplay.imageUpdate(x, y, w, h, data);
        }
        this.imagePanel.imageUpdate(x, y, w, h, data);
    }

    public void imageFill(int x, int y, int w, int h, Color c) {
        if (this.fileDisplay != null) {
            this.fileDisplay.imageFill(x, y, w, h, c);
        }
        this.imagePanel.imageFill(x, y, w, h, c);
    }

    public void imageEnd() {
        if (this.fileDisplay != null) {
            this.fileDisplay.imageEnd();
        }
        this.imagePanel.imageEnd();
    }

    public JFrame getFrame() {
        return this.frame;
    }
}

